<?php
session_start();
include("config.php");

$_SESSION['errorimport'] = "";

if(!isset($_SESSION['id'])){
	header('location: login.php');
}
else{
	if(!preg_match("#Confirmation#",$_SESSION['roles']) AND ($_SESSION['type'] == "moderator")){	
		header('location: 404.php');
	}
}

if(isset($_SESSION['id']) AND isset($_SESSION['fullname'])){
?>
<!DOCTYPE html>
<html lang="zxx">
	<head>
		<meta charset="utf-8">
		<title><?php echo $settings['appname'];?> - CPanel</title>
		<meta name="description" content="<?php echo $settings['appname'];?> - CPanel">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<meta name="robots" content="noindex,nofollow" />
		<!-- General CSS Settings -->
		<link rel="stylesheet" href="css/general_style.css">
		<!-- Main Style of the template -->
		<link rel="stylesheet" href="css/main_style.php">
		<!-- Landing Page Style -->
		<link rel="stylesheet" href="css/reset_style.css">
		<!-- Awesomefont -->
		<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.4.1/css/all.css" integrity="sha384-5sAR7xN1Nv6T6+dT2mhtzEpVJvfS3NScPQTrOxhwjIuvcA67KV2R5Jz6kr4abQsz" crossorigin="anonymous">
		<!-- QRCode Scanner -->
		<link rel="stylesheet" type="text/css" href="css/qrcode-reader.css" />
		<!-- DateRangePicker -->
		<link rel="stylesheet" type="text/css" href="css/daterangepicker.css" />
		<!-- Fav Icon -->
		<link rel="shortcut icon" href="../favicon.ico">
		<?php include("onesignal.php");?>
	</head>
	<body>

		<!-- Wrapper -->
		<div class="lx-wrapper">
			<!-- Header -->
			<div class="lx-header">
				<?php include('header.php');?>
			</div>
			<!-- Main -->
			<div class="lx-main">
				<div class="lx-main-leftside">
					<?php include('mainmenu.php');?>
				</div>
				<!-- Main Content -->
				<div class="lx-main-content">
					<div class="lx-page-header">
						<h2>Confirmation
							<?php
							if($_SESSION['type'] != "client" AND $_SESSION['type'] != "affiliate"){
								$extrareq = $userwhere;
								if($_SESSION['type'] == "dlm" AND $_SESSION['roles'] == "Affichage commun"){
									$extrareq = " AND (dlm='".$_SESSION['id']."' OR city IN(SELECT city FROM shippingfees WHERE dlm='".$_SESSION['id']."' AND trash='1'))";
								}
								$back = $bdd->query("SELECT id FROM commands WHERE state='Reporté' AND phase='confirmation' AND (datereported BETWEEN '".(strtotime(date("d-m-Y"))-3600)."' AND '".(strtotime(date("d-m-Y"))+(60*60*24)-1)."') AND trash='1'".$extrareq);
								if($back->rowCount() > 0){
									?>
							<a href="javascript:;" class="lx-reported-blink blink" data-state="Reporté" data-datereport="<?php echo date("d/m/Y")." - ".date("d/m/Y");?>"><?php echo $back->rowCount();?> reporté</a>
									<?php
								}
								$back = $bdd->query("SELECT id FROM commands WHERE state='Confirmé à la date' AND phase='confirmation' AND (datereported BETWEEN '".(strtotime(date("d-m-Y"))-3600)."' AND '".(strtotime(date("d-m-Y"))+(60*60*24)-1)."') AND trash='1'".$extrareq);
								if($back->rowCount() > 0){
									?>
							<a href="javascript:;" class="lx-confirmed-blink blink" data-datereport="<?php echo date("d/m/Y");?>"><?php echo $back->rowCount();?> Confirmé à la date</a>
									<?php
								}
								$back = $bdd->query("SELECT id FROM commands WHERE state IN('INJ (à la date)','\"Injoignable\"','\"Pas de reponse 3\"','\"Pas de reponse 2\"','\"Pas de reponse 1\"','Injoignable','Pas de reponse 3','Pas de reponse 2','Pas de reponse 1') AND phase='confirmation' AND dateupdate < '".(strtotime(date("d-m-Y"))-(60*60*24))."' AND trash='1'".$extrareq);
								if($back->rowCount() > 0){
									?>
							<a href="javascript:;" class="lx-reported-blink blink" data-state='INJ (à la date),"Injoignable","Pas de reponse 3","Pas de reponse 2","Pas de reponse 1",Injoignable,Pas de reponse 3,Pas de reponse 2,Pas de reponse 1' data-datereport="" data-dateupdate="<?php echo date("d/m/Y",(strtotime(date("d-m-Y"))-(60*60*24)))?>"><?php echo $back->rowCount();?> PDR & Injoignable</a>
									<?php
								}
							}
							?>
						</h2>
					</div>
					<?php
					$back = $bdd->query("SELECT fullname,dateactive FROM users WHERE type='worker' OR type='moderator' AND trash='1'");
					if($_SESSION['type'] == "moderator" AND $back->rowCount() > 0){
					?>
					<div class="lx-g1">
						<div class="lx-stats-bloc">
							<ul class="lx-workers-state">
								<?php
								while($row = $back->fetch()){
									$class = " lx-connected";
									if($row['dateactive'] != ""){
										if($row['dateactive'] < (time() - (60*20))){
											$class = " lx-disconnected";
										}
										elseif($row['dateactive'] < (time() - (60*10))){
											$class = " lx-halfconnected";
										}
									}
									else{
										$class = " lx-disconnected";
									}
									?>
								<li><i class="fa fa-circle<?php echo $class;?>"></i> <?php echo $row['fullname'];?></li>
									<?php
								}
								?>
							</ul>
						</div>
					</div>
					<?php
					}					
					?>
					<div class="lx-clear-fix"></div>
					<div class="lx-page-content">
						<div class="lx-g1">
							<div class="lx-keyword">
								<label><a href="javascript:;" class="lx-search-keyword"><i class="fa fa-search"></i></a><input type="text" name="keyword" id="keyword" placeholder="Mot clé" data-table="commands" /></label>
								<label style="<?php if($_SESSION['type'] != "moderator" OR $myclients != ""){echo "display:none;";}?>">
									<select name="manager" id="manager">
										<option value="">Tous les manager</option>
										<?php
										$back = $bdd->query("SELECT id,fullname,store FROM users WHERE type='moderator' AND roles LIKE '%Responsable%' AND trash='1' ORDER BY fullname");
										while($row = $back->fetch()){
											?>
										<option value="<?php echo $row['id'];?>"><?php echo $row['fullname'];?></option>
											<?php 
										}
										?>
									</select>
								</label>
								<label class="lx-advanced-select" style="<?php if($_SESSION['type'] != "moderator"){echo "display:none;";}?>">
									<i class="fa fa-caret-down"></i>
									<input type="text" name="worker" id="workers" placeholder="Choisissez un employé" data-ids="" readonly />
									<div>
										<a href="javascript:;" class="lx-state-empty">Vider</a>
										<a href="javascript:;" class="lx-state-filter">Filtrer</a>
										<div class="lx-clear-fix"></div>
										<input type="text" name="searchadvanced" style="margin-bottom:20px;" />
										<ul>
											<?php
											$back = $bdd->query("SELECT id,fullname,store FROM users WHERE type='worker' AND trash='1' ORDER BY fullname");
											if($_SESSION['type']=="worker"){
												$back = $bdd->query("SELECT id,fullname,store FROM users WHERE type='worker' AND id='".$_SESSION['id']."' AND trash='1' ORDER BY fullname");		
											}
											while($row = $back->fetch()){
												?>
											<li><label><input type="checkbox" value="<?php echo $row['fullname'];?>" data-ids="<?php echo $row['id'];?>" /> <?php echo $row['fullname'];?><del class="checkmark"></del></label></li>
												<?php
											}
											?>
										</ul>
									</div>
								</label>
								<label style="<?php if($_SESSION['type'] != "moderator" OR preg_match("#Responsable#",$_SESSION['roles'])){echo "display:none;";}?>">
									<select name="type" id="type">
										<option value="">Tous les compte</option>
										<option value="client" <?php echo preg_match("#Responsable seller#",$_SESSION['roles'])?"selected":"";?>>Clients Seller</option>
										<option value="affiliate" <?php echo preg_match("#Responsable affiliate#",$_SESSION['roles'])?"selected":"";?>>Clients Affiliate</option>
									</select>
								</label>								
								<label class="lx-advanced-select" style="<?php if($_SESSION['type'] != "moderator" OR preg_match("#Responsable affiliate#",$_SESSION['roles'])){echo "display:none;";}?>">
									<i class="fa fa-caret-down"></i>
									<input type="text" name="client" id="clients" placeholder="Choisissez un client seller" data-ids="" readonly />
									<div>
										<a href="javascript:;" class="lx-state-empty">Vider</a>
										<a href="javascript:;" class="lx-state-filter">Filtrer</a>
										<div class="lx-clear-fix"></div>
										<input type="text" name="searchadvanced" style="margin-bottom:20px;" />
										<ul>
											<?php
											$back = $bdd->query("SELECT id,fullname,store FROM users WHERE type IN('client') AND trash='1'".$myclientsids." ORDER BY fullname");
											if($_SESSION['type']=="client"){
												$back = $bdd->query("SELECT id,fullname,store FROM users WHERE type IN('client') AND id='".$_SESSION['id']."' AND trash='1' ORDER BY fullname");		
											}
											while($row = $back->fetch()){
												?>
											<li><label><input type="checkbox" value="<?php echo $row['fullname']!=""?$row['fullname']:$row['store'];?>" data-ids="<?php echo $row['id'];?>" /> <?php echo $row['store']." (".$row['fullname'].")";?><del class="checkmark"></del></label></li>
												<?php
											}
											?>
										</ul>
									</div>
								</label>
								<label class="lx-advanced-select" style="<?php if($_SESSION['type'] != "moderator" OR preg_match("#Responsable seller#",$_SESSION['roles'])){echo "display:none;";}?>">
									<i class="fa fa-caret-down"></i>
									<input type="text" name="clientaff" id="clientsaff" placeholder="Choisissez un client affiliate" data-ids="" readonly />
									<div>
										<a href="javascript:;" class="lx-state-empty">Vider</a>
										<a href="javascript:;" class="lx-state-filter">Filtrer</a>
										<div class="lx-clear-fix"></div>
										<input type="text" name="searchadvanced" style="margin-bottom:20px;" />
										<ul>
											<?php
											$back = $bdd->query("SELECT id,fullname,store FROM users WHERE type IN('affiliate') AND trash='1'".$myclientsids." ORDER BY fullname");
											if($_SESSION['type']=="client"){
												$back = $bdd->query("SELECT id,fullname,store FROM users WHERE type IN('affiliate') AND id='".$_SESSION['id']."' AND trash='1' ORDER BY fullname");		
											}
											while($row = $back->fetch()){
												?>
											<li><label><input type="checkbox" value="<?php echo $row['fullname']!=""?$row['fullname']:$row['store'];?>" data-ids="<?php echo $row['id'];?>" /> <?php echo $row['store']." (".$row['fullname'].")";?><del class="checkmark"></del></label></li>
												<?php
											}
											?>
										</ul>
									</div>
								</label>
								<label class="lx-advanced-select">
									<i class="fa fa-caret-down"></i>
									<input type="text" name="store" id="stores" placeholder="Choisissez une boutique" data-ids="" readonly />
									<div>
										<a href="javascript:;" class="lx-state-empty">Vider</a>
										<a href="javascript:;" class="lx-state-filter">Filtrer</a>
										<div class="lx-clear-fix"></div>
										<input type="text" name="searchadvanced" style="margin-bottom:20px;" />
										<ul>
											<?php
											$back = $bdd->query("SELECT * FROM stores WHERE trash='1'");		
											if($_SESSION['type'] == "client"){
												$back = $bdd->query("SELECT * FROM stores WHERE trash='1'".$userwhere);		
											}
											if($_SESSION['type'] == "worker"){
												$back = $bdd->query("SELECT * FROM stores WHERE trash='1' AND title IN('".str_replace(",","','",$_SESSION['clientslist'])."')");		
											}
											while($row = $back->fetch()){
												?>
											<li><label><input type="checkbox" value="<?php echo $row['title'];?>" data-ids="<?php echo $row['title'];?>" /> <?php echo $row['title'];?><del class="checkmark"></del></label></li>
												<?php
											}
											?>
										</ul>
									</div>
								</label>
								<label class="lx-advanced-select">
									<i class="fa fa-caret-down"></i>
									<input type="text" name="city" id="cities" placeholder="Choisissez une ville" data-ids="" readonly />
									<div>
										<a href="javascript:;" class="lx-state-empty">Vider</a>
										<a href="javascript:;" class="lx-state-filter">Filtrer</a>
										<div class="lx-clear-fix"></div>
										<input type="text" name="searchadvanced" style="margin-bottom:20px;" />
										<ul>
											<?php
											$back = $bdd->query("SELECT DISTINCT city FROM shippingfees WHERE trash='1' ORDER BY city");
											if($_SESSION['type'] == "dlm"){
												$back = $bdd->query("SELECT DISTINCT city FROM shippingfees WHERE trash='1' AND dlm='".$_SESSION['id']."' ORDER BY city");
											}
											while($row = $back->fetch()){
												?>
											<li><label><input type="checkbox" value="<?php echo $row['city'];?>" data-ids="<?php echo $row['city'];?>" /> <?php echo $row['city'];?><del class="checkmark"></del></label></li>
												<?php
											}
											?>
										</ul>
									</div>
								</label>
								<label class="lx-advanced-select" style="<?php if($_SESSION['type'] == "dlm"){echo "display:none;";}?>">
									<i class="fa fa-caret-down"></i>
									<input type="text" name="product" id="product" placeholder="Choisissez un produit" data-ids="" readonly />
									<div>
										<a href="javascript:;" class="lx-state-empty">Vider</a>
										<a href="javascript:;" class="lx-state-filter">Filtrer</a>
										<div class="lx-clear-fix"></div>
										<input type="text" name="searchadvanced" style="margin-bottom:20px;" />
										<ul>
											<?php
											$back = $bdd->query("SELECT id,title FROM stocks WHERE trash='1' ORDER BY id");
											if($_SESSION['type'] == "client"){
												$back = $bdd->query("SELECT id,title FROM stocks WHERE client='".$_SESSION['id']."' AND trash='1' ORDER BY id");
											}
											if($_SESSION['type'] == "dlm"){
												$back = $bdd->query("SELECT id,title FROM stocks WHERE 1=2");
											}
											if($_SESSION['type'] == "affiliate"){
												$back = $bdd->query("SELECT id,title FROM stocks WHERE (client='0' OR affiliate='on') AND trash='1' ORDER BY id");
											}
											while($row = $back->fetch()){
												?>
											<li><label><input type="checkbox" value="<?php echo $row['title'];?>" data-ids="<?php echo $row['id'];?>" /> <?php echo $row['title'];?><del class="checkmark"></del></label></li>
												<?php
											}
											?>
										</ul>
									</div>
								</label>
								<label class="lx-advanced-select">
									<i class="fa fa-caret-down"></i>
									<input type="text" name="state" id="states" value="<?php if(isset($_GET['s'])){if($_GET['s'] != ""){echo $_GET['s'];}}?>" placeholder="Choisissez une état" readonly />
									<div>
										<a href="javascript:;" class="lx-state-empty">Vider</a>
										<a href="javascript:;" class="lx-state-filter">Filtrer</a>
										<div class="lx-clear-fix"></div>
										<input type="text" name="searchadvanced" style="margin-bottom:20px;" />
										<ul>
											<?php
											$back = $bdd->query("SELECT state FROM trackingstates WHERE trash='1' AND phase LIKE '%Confirmation%' ORDER BY state");
											while($row = $back->fetch()){
												?>
											<li><label><input type="checkbox" value="<?php echo $row['state'];?>" <?php if(isset($_GET['s'])){if(preg_match("#".str_replace(",","|",$_GET['s'])."#",$row['state'])){echo "checked";}}?> /> <?php echo $row['state'];?><del class="checkmark"></del></label></li>
												<?php
											}
											?>
										</ul>
									</div>
								</label>
								<label><input type="text" name="nbcalls" id="nbcalls" data-table="commands" placeholder="Nombre des appels" /></label>
								<label><input type="text" name="dateadd" id="dateadd" data-table="commands" value="<?php echo date("d/m/Y",time()-2592000)." - ".date("d/m/Y");?>" placeholder="Date ajout" readonly style="background:white;cursor:pointer;" /></label>
								<input type="hidden" name="datestart" id="datestart" value="<?php echo date("d/m/Y",time()-2592000);?>" />
								<input type="hidden" name="dateend" id="dateend" value="<?php echo date("d/m/Y");?>" />
								<label><input type="text" name="dateupdate" id="dateupdate" data-table="commands" placeholder="Date mise à jour" readonly style="background:white;cursor:pointer;" /></label>
								<input type="hidden" name="datestartupdate" id="datestartupdate" />
								<input type="hidden" name="dateendupdate" id="dateendupdate" />
								<label><input type="text" name="datereport" id="datereport" data-table="commands" placeholder="Date reporté" readonly style="background:white;cursor:pointer;" /></label>
								<input type="hidden" name="datestartreport" id="datestartreport" />
								<input type="hidden" name="dateendreport" id="dateendreport" />
								<input type="hidden" name="sortby" value="" />
								<input type="hidden" name="orderby" value="DESC" />
							</div>
							<div class="lx-add-form">
								<a href="javascript:;" class="lx-new lx-new-command lx-open-popup" data-title="command">+ Nouveau commande</a>
								<?php
								if($_SESSION['type'] != "worker"){
									?>
								<a href="javascript:;" class="lx-new lx-export-commands"><i class="fa fa-download"></i> Exporter</a>
								<a href="javascript:;" class="lx-new lx-open-popup" data-title="importer"><i class="fa fa-upload"></i> Importer</a>
									<?php
									if($_SESSION['type'] == "affiliate"){
									?>
								<a href="ExampleImportationAffiliate.xlsx" class="lx-new">Examplaire</a>
									<?php
									}
									else{
									?>
								<a href="ExampleImportationColis.xlsx" class="lx-new">Examplaire</a>
									<?php										
									}
									?>
								<a href="errorimport.php" class="lx-new lx-error-import" style="display:none;">Commandes non importés</a>
									<?php
								}
								else{
								?>
								<a href="javascript:;" class="lx-new lx-grab-confirmation">+ Ajouter</a>
								<?php									
								}
								if($_SESSION['type'] == "moderator"){
									?>
								<a href="javascript:;" class="lx-new lx-assign-command lx-open-popup" data-title="assign">Affecter</a>
								<a href="javascript:;" class="lx-new qrcode-reader" id="openreader-single" data-qrr-target="#qrcode" data-qrr-audio-feedback="true">Scan QRCode</a>
								<input type="hidden" id="qrcode" />
									<?php
								}
								?>
							</div>
							<div class="lx-quick-filter">
								<?php 
								$req = $myclients;
								$back = $bdd->query("SELECT id FROM commands WHERE phase='confirmation' AND state='Nouveau' AND trash='1'".$userwhere.$req);
								if($back->rowCount() > 0){
									?>
								<a href="javascript:;" data-states="Nouveau" style="background:#828282;">Nouveau (<?php echo $back->rowCount();?>)</a>
									<?php
								}
								$back = $bdd->query("SELECT id FROM commands WHERE phase='confirmation' AND state='Confirmé' AND trash='1'".$userwhere.$req);
								if($back->rowCount() > 0){
									?>
								<a href="javascript:;" data-states="Confirmé" style="background:#7EC855;">Confirmé (<?php echo $back->rowCount();?>)</a>
									<?php
								}
								$back = $bdd->query("SELECT id FROM commands WHERE phase='confirmation' AND state='Reporté' AND trash='1'".$userwhere.$req);
								if($back->rowCount() > 0){
									?>
								<a href="javascript:;" data-states="Reporté" style="background:#39add1;">Reporté (<?php echo $back->rowCount();?>)</a>
									<?php
								}
								$back = $bdd->query("SELECT id FROM commands WHERE phase='confirmation' AND (state LIKE '%Pas de réponse%' OR state LIKE '%Injoignable%') AND trash='1'".$userwhere.$req);
								if($back->rowCount() > 0){
									?>
								<a href="javascript:;" style="background:#FF7700;" data-states="Pas de réponse,Pas de réponse 2 fois,Pas de réponse 3 fois,Pas de réponse 4 fois,Pas de réponse 5 fois,Injoignable">PDR & Inj (<?php echo $back->rowCount();?>)</a>
									<?php
								}
								$back = $bdd->query("SELECT id FROM commands WHERE phase='confirmation' AND state IN('Annulé') AND trash='1'".$userwhere.$req);
								if($back->rowCount() > 0){
									?>
								<a href="javascript:;" data-states="Annulé" style="background:#CC0000;">Annulé (<?php echo $back->rowCount();?>)</a>
									<?php
								}
								?>
							</div>
							<div class="lx-table lx-table-commands">

							</div>
							<?php
							if($_SESSION['type'] == "moderator"){
							?>
							<div class="lx-action-bulk">
								<label><span>Action: </span>
									<select name="statebulk">
										<option value="">Choisissez une action</option>
										<option value="delete">Supprimer vers corbeille</option>
										<option value="deletepermenantly">Supprimer definitivement</option>
										<option value="restore">Restaurer</option>
										<option value="collect">Ramasser</option>
										<?php
										$back = $bdd->query("SELECT state FROM trackingstates WHERE phase='Confirmation' AND trash='1' ORDER BY state");
										while($row = $back->fetch()){
											?>
										<option value="<?php echo $row['state'];?>"><?php echo $row['state'];?></option>
											<?php 
										}
										?>
									</select>
								</label>
								<a href="javascript:;">Appliquer</a>
							</div>
							<?php
							}
							$nb = 20;
							if($parametres['nbrows'] != "" AND $parametres['nbrows'] != "0"){
								$nb = $parametres['nbrows'];
							}						
							?>
							<div class="lx-action-bulk">
								<label><span>Afficher: </span>
									<select name="nbrows">
										<option value="20" <?php if($nb==20){echo "selected";}?>>20</option>
										<option value="50" <?php if($nb==50){echo "selected";}?>>50</option>
										<option value="100" <?php if($nb==100){echo "selected";}?>>100</option>
										<option value="250" <?php if($nb==250){echo "selected";}?>>250</option>
										<option value="500" <?php if($nb==500){echo "selected";}?>>500</option>
										<option value="1000" <?php if($nb==500){echo "selected";}?>>1000</option>
									</select>
								</label><span>lignes par page</span>
							</div>
							<?php
							$back = $bdd->query("SELECT COUNT(*) AS nb FROM commands WHERE trash='1' AND phase='confirmation'".$userwhere);
							$row = $back->fetch();
							?>
							<div class="lx-pagination" style="<?php if($row['nb'] <= $nb){echo "display:none;";}?>">
								<?php
								$nbpages = ceil($row['nb']/$nb);
								?>
								<ul data-table="confirmation" data-state="1" data-start="0" data-nbpage="<?php echo $nb;?>" data-posts="<?php echo $row['nb'];?>">
									<li><span>Page <ins>1</ins> sur <abbr><?php echo $nbpages;?></abbr></span></li>
									<li><a href="javascript:;" class="previous disabled"><i class="fa fa-angle-left"></i></a></li>
									<li>
										<select id="pgbumber">
											<?php
											for($i=1;$i<=$nbpages;$i++){
												?>
											<option value="<?php echo ($i-1);?>"><?php echo $i;?></option>
												<?php
											}
											?>
										</select>
									</li>
									<li><a href="javascript:;" class="next <?php if($nbpages == 1){echo 'disabled';}?>"><i class="fa fa-angle-right"></i></a></li>
								</ul>
								<div class="lx-clear-fix"></div>
							</div>
							<div class="lx-clear-fix"></div>
						</div>
						<div class="lx-clear-fix"></div>
					</div>
					<div class="lx-clear-fix"></div>
				</div>
				<div class="lx-clear-fix"></div>
			</div>
			<!-- End Popup -->
			<div tabindex="0" class="lx-popup command confirmation">
				<div class="lx-popup-inside">
					<div class="lx-popup-content">
						<a href="javascript:;"><i class="material-icons">close</i></a>
						<div class="lx-popup-details">
							<div class="lx-form">
								<div class="lx-form-title">
									<h3>Mise à jour commande</h3>
								</div>
								<div class="lx-add-form">
									<form action="#" method="post" id="commandsform">
										<div class="lx-textfield lx-g1 lx-pb-0" style="<?php if($_SESSION['type'] != "moderator"){echo "display:none;";}?>">
											<label><span>Client:</span>
												<select name="client" data-isnotempty="" data-message="Choisissez un client!!">
													<option value="">Choisissez un client</option>
													<?php
													$back = $bdd->query("SELECT id,fullname,store FROM users WHERE type IN('client','affiliate') AND trash='1'".$myclientsids." ORDER BY fullname");
													if($_SESSION['type'] == "client"){
														$back = $bdd->query("SELECT id,fullname,store FROM users WHERE type IN('client','affiliate') AND id='".$_SESSION['id']."' AND trash='1' ORDER BY fullname");		
													}
													while($row = $back->fetch()){
														?>
													<option value="<?php echo $row['id'];?>" <?php if($row['id'] == $_SESSION['id']){echo "selected";}?>><?php echo $row['store']." (".$row['fullname'].")";?></option>
														<?php 
													}
													?>
												</select>
											</label>
										</div>
										<div class="lx-textfield lx-g1 lx-pb-0">
											<label><span>Boutique:</span>
												<select name="stores" data-isnotempty="" data-message="Choisissez une boutique!!">
													<option value="">Choisissez une boutique</option>
													<?php
													$back = $bdd->query("SELECT * FROM stores WHERE trash='1'");		
													if($_SESSION['type'] == "client"){
														$back = $bdd->query("SELECT * FROM stores WHERE trash='1'".$userwhere);		
													}
													if($_SESSION['type'] == "worker"){
														$back = $bdd->query("SELECT * FROM stores WHERE trash='1' AND title IN('".str_replace(",","','",$_SESSION['clientslist'])."')");		
													}
													while($row = $back->fetch()){
														?>
													<option value="<?php echo $row['title'];?>" data-client="<?php echo $row['client']?>"><?php echo $row['title'];?></option>
														<?php 
													}
													?>
												</select>
											</label>
										</div>
										<div class="lx-clear-fix"></div>
										<div style="<?php if($settings['reseller'] == "0"){echo "display:none;";}?>">
											<div class="lx-textfield lx-g2 lx-pb-0">
												<label><span>Nom Vendeur: </span><input type="text" name="clientname" /></label>
											</div>
											<div class="lx-textfield lx-g2 lx-pb-0">
												<label><span>Téléphone Vendeur: </span><input type="text" name="clientphone" /></label>
											</div>
										</div>
										<div class="lx-clear-fix"></div>
										<div class="lx-textfield lx-g3 lx-pb-0" style="display:none;">
											<label><span>Code d'envoi: </span><input type="text" name="code" /></label>
										</div>
										<div class="lx-textfield lx-g2 lx-pb-0">
											<label><span>Destinataire: </span><input type="text" name="fullname" data-isnotempty="" data-message="Saisissez un destinataire!!" /></label>
										</div>
										<div class="lx-textfield lx-g2 lx-pb-0">
											<label><span>Téléphone: </span><input type="text" name="phone" data-isphone="" data-message="Ex: 06xxxxxxxx, 07xxxxxxxx ..." /></label>
										</div>
										<div class="lx-clear-fix"></div>
										<div class="lx-textfield lx-g1 lx-pb-0" style="display:none;">
											<label><span>Livreur:</span>
												<select name="dlm" data-isnotempty="" data-message="Choisissez un livreur!!">
													<option value="0">Choisissez un livreur</option>
													<?php
													$back = $bdd->query("SELECT id,fullname FROM users WHERE type='dlm' AND trash='1' ORDER BY fullname");
													while($row = $back->fetch()){
														?>
													<option value="<?php echo $row['id'];?>"><?php echo $row['fullname'];?></option>
														<?php 
													}
													?>
												</select>
											</label>
										</div>
										<div class="lx-textfield lx-g1 lx-pb-0">
											<label><span>Ville:</span>
												<select name="city" class="todropdown" data-isnotempty="" data-message="Choisissez une ville!!">
													<option value="">Choisissez une ville</option>
													<?php
													$back = $bdd->query("SELECT DISTINCT city FROM shippingfees ORDER BY city");
													while($row = $back->fetch()){
														?>
													<option value="<?php echo $row['city'];?>"><?php echo $row['city'];?></option>
														<?php 
													}
													?>
												</select>
											</label>
										</div>
										<div class="lx-textfield lx-g1 lx-pb-0">
											<label><span>Addresse: </span><input type="text" name="address" data-isnotempty="" data-message="Saisissez une adresse!!" /></label>
										</div>	
										<div class="lx-clear-fix"></div>
										<div class="fromstock">
											<?php
											$back = $bdd->query("SELECT id,title,qty,price FROM stocks WHERE trash='1' ORDER BY id");
											if($_SESSION['type'] == "client"){
												if($_SESSION['roles'] == "Produits Seller"){
													$back = $bdd->query("SELECT id,title,qty,price FROM stocks WHERE (client='".$_SESSION['id']."' OR seller='on') AND trash='1' ORDER BY id");
												}
												else{
													$back = $bdd->query("SELECT id,title,qty,price FROM stocks WHERE client='".$_SESSION['id']."' AND trash='1' ORDER BY id");
												}
											}	
											if($_SESSION['type'] == "affiliate"){
												$back = $bdd->query("SELECT id,title,price FROM stocks WHERE (client='0' OR affiliate='on') AND trash='1' ORDER BY id");
											}
											?>
											<div>
												<div class="lx-textfield lx-g<?php echo $_SESSION['type']=="affiliate"?"1":"2";?> lx-pb-0">
													<label><span>Produit:</span>
														<select name="product" data-isnumber="" data-message="Choisissez un produit">
															<option value="">Choisissez un produit</option>
															<?php
															while($row = $back->fetch()){
																?>
															<option value="<?php echo $row['id'];?>" data-price="<?php echo $row['price'];?>"><?php echo $row['title'];?></option>
																<?php
															}
															?>
														</select>
													</label>
												</div>
												<div class="lx-textfield lx-g2 lx-pb-0" style="<?php echo $_SESSION['type']=="affiliate"?"display:none;":"";?>">
													<label><span>Quantité: </span><input type="text" name="qty" /></label>
												</div>
												<div class="lx-clear-fix"></div>
											</div>
											<?php
											if($_SESSION['type']!="affiliate"){
											?>
											<a href="javascript:;" class="lx-add-other-stock">Ajouter autre produit</a>
											<?php
											}
											?>
										</div>
										<div class="lx-clear-fix"></div>
										<div class="lx-textfield lx-g1 lx-pb-0">
											<label><span>Prix: </span><input type="text" name="price" data-isnumber="" data-message="Saisissez un prix" /></label>
										</div>	
										<div class="lx-clear-fix"></div>
										<div class="lx-textfield lx-g1 lx-pb-0">
											<label><span>Note: </span><textarea name="note" /></textarea></label>
										</div>			
										<div class="lx-clear-fix"></div>
										<div class="lx-textfield lx-g1 lx-pb-0">
											<label><input type="checkbox" name="change" value="0" /> Change (S'il y a un colis a retourné)<del class="checkmark"></del></label>
										</div>
										<div class="lx-clear-fix"></div>
										<div class="lx-textfield lx-g1 lx-pb-0">
											<label><input type="checkbox" name="openpackage" value="1" /> Permettre l'ouverture de colis par le client<del class="checkmark"></del></label>
										</div>												
										<div class="lx-clear-fix"></div>							
										<div class="lx-submit lx-g1 lx-pb-0">
											<input type="hidden" name="idclient" value="<?php echo $_SESSION['type']=="client"?$_SESSION['id']:"47";?>" />
											<input type="hidden" name="idticket" id="idticket" />
											<input type="hidden" name="phase" value="confirmation" />
											<input type="hidden" name="state" value="Nouveau" />
											<input type="hidden" name="id" value="0" />
											<a href="javascript:;">Enregistrer</a>
										</div>
									</form>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- End Popup -->	
			<div tabindex="0" class="lx-popup editstate">
				<div class="lx-popup-inside">
					<div class="lx-popup-content">
						<a href="javascript:;"><i class="material-icons">close</i></a>
						<div class="lx-popup-details">
							<div class="lx-form">
								<div class="lx-form-title">
									<h3>Modifier état</h3>
								</div>
								<div class="lx-add-form">
									<form action="#" method="post" id="editstateform">
										<div class="lx-textfield lx-g1 lx-pb-0">
											<?php
											$agent = "Modérateur";
											if($_SESSION['type'] == "dlm"){
												$agent = "Livreur";
											}
											if($_SESSION['type'] == "client"){
												$agent = "Client";
											}
											$back = $bdd->query("SELECT state,color FROM trackingstates WHERE agent LIKE '%".$agent."%' AND phase LIKE '%Confirmation%' AND trash='1' ORDER BY state");	
											while($row = $back->fetch()){
												?>
											<a href="javascript:;" class="lx-coli-state-delivarymen" data-state="<?php echo $row['state'];?>" style="font-weight:500;background:<?php echo $row['color'];?>;color:#FFFFFF;"><?php echo $row['state'];?></a>
												<?php
											}
											?>
											<input type="hidden" name="state" data-required="yes" /></label>
										</div>
										<div class="lx-textfield lx-g1 lx-pb-0 datereported" style="display:none;">
											<label><span>Date reporté: </span><input type="text" name="datereported" /></label>
										</div>
										<div class="lx-clear-fix"></div>
										<div class="lx-textfield lx-g1 lx-pb-0">
											<label><span>Commentaire: </span><textarea name="comment" /></textarea></label>
										</div>
										<div class="lx-clear-fix"></div>
										<div class="lx-submit lx-g1 lx-pb-0">
											<input type="hidden" name="id" value="0" />
											<a href="javascript:;">Enregistrer</a>
										</div>
									</form>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- End Popup -->
			<div tabindex="0" class="lx-popup importer">
				<div class="lx-popup-inside">
					<div class="lx-popup-content">
						<a href="javascript:;"><i class="material-icons">close</i></a>
						<div class="lx-popup-details">
							<div class="lx-form">
								<div class="lx-form-title">
									<h3>Importer commandes</h3>
								</div>
								<div class="lx-add-form">
									<form action="#" method="post" id="importform" enctype="multipart/form-data">
										<div class="lx-textfield lx-g1 lx-pb-0" style="<?php if($_SESSION['type'] != "moderator"){echo "display:none;";}?>">
											<label><span>Format:</span>
												<select name="format" id="importformat" data-isnotempty="" data-message="Choisissez un format!!">
													<option value="Stockout" selected>Stockout</option>
													<option value="Sendit">Sendit</option>
												</select>
											</label>
										</div>
										<div class="lx-textfield lx-g1 lx-pb-0" style="<?php if($_SESSION['type'] != "moderator"){echo "display:none;";}?>">
											<label><span>Client:</span>
												<select name="client" id="importclient" data-isnotempty="" data-message="Choisissez un client!!">
													<option value="">Choisissez un client</option>
													<?php
													$back = $bdd->query("SELECT id,fullname,store FROM users WHERE type IN('client','affiliate') AND trash='1'".$myclientsids." ORDER BY fullname");
													if($_SESSION['type'] == "client"){
														$back = $bdd->query("SELECT id,fullname,store FROM users WHERE type IN('client','affiliate') AND id='".$_SESSION['id']."' AND trash='1' ORDER BY fullname");		
													}
													while($row = $back->fetch()){
														?>
													<option value="<?php echo $row['id'];?>" <?php if($row['id'] == $_SESSION['id']){echo "selected";}?>><?php echo $row['store']." (".$row['fullname'].")";?></option>
														<?php 
													}
													?>
												</select>
											</label>
										</div>
										<div class="lx-clear-fix"></div>
										<div class="lx-textfield lx-g1 lx-pb-0">
											<div class="lx-importer">
												<input type="file" name="xlsfile" id="importcommands" accept="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet" />
												<span>Choisissez un fichier (excel)</span>
											</div>
										</div>
										<div class="lx-clear-fix"></div>
										<div class="lx-submit lx-g1 lx-pb-0">
											<input type="hidden" name="phase" id="importphase" value="confirmation" />
											<input type="hidden" name="state" id="importstate" value="Nouveau" />
											<input type="hidden" name="id" value="0" />
											<a href="javascript:;">Importer</a>
										</div>
									</form>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- End Popup -->	
			<div tabindex="0" class="lx-popup assign">
				<div class="lx-popup-inside">
					<div class="lx-popup-content">
						<a href="javascript:;"><i class="material-icons">close</i></a>
						<div class="lx-popup-details">
							<div class="lx-form">
								<div class="lx-form-title">
									<h3>Affecter des commandes à un autre employé</h3>
								</div>
								<div class="lx-add-form">
									<form action="#" method="post" id="assignform">
										<div class="lx-textfield lx-g1 lx-pb-0">
											<label><span>Employé:</span>
												<select name="worker" data-isnotempty="" data-message="Choisissez un employé!!">
													<option value="0">Choisissez un employé</option>
													<?php
													$back = $bdd->query("SELECT id,fullname FROM users WHERE type='worker' AND trash='1' ORDER BY fullname");
													while($row = $back->fetch()){
														?>
													<option value="<?php echo $row['id'];?>"><?php echo $row['fullname'];?></option>
														<?php 
													}
													?>
												</select>
											</label>
										</div>
										<div class="lx-clear-fix"></div>
										<div class="lx-submit lx-g1 lx-pb-0">
											<input type="hidden" name="id" value="0" />
											<a href="javascript:;">Enregistrer</a>
										</div>
									</form>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- End Popup -->
			<div tabindex="0" class="lx-popup phone">
				<div class="lx-popup-inside">
					<div class="lx-popup-content">
						<a href="javascript:;"><i class="material-icons">close</i></a>
						<div class="lx-popup-details">
							<div class="lx-form">
								<div class="lx-form-title">
									<h3>Téléphone</h3>
								</div>
								<div class="lx-add-form">
									<div class="lx-phone-layouts">
										<a href="#">
											<img src="images/phone-icon.png" />
										</a>
										<a href="#">
											<img src="images/sms-icon.png" />
										</a>
										<a href="#" target="_blank">
											<img src="images/whatsapp-icon.png" />
										</a>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- End Popup -->
			<div tabindex="0" class="lx-popup commandhistory">
				<div class="lx-popup-inside">
					<div class="lx-popup-content">
						<a href="javascript:;"><i class="material-icons">close</i></a>
						<div class="lx-popup-details">
							<div class="lx-form">
								<div class="lx-form-title">
									<h3>Historique du commande</h3>
								</div>
								<div class="lx-add-form">

								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- End Popup -->	
			<div tabindex="0" class="lx-popup deleterecord">
				<div class="lx-popup-inside">
					<div class="lx-popup-content">
						<a href="javascript:;"><i class="material-icons">close</i></a>
						<div class="lx-popup-details">
							<div class="lx-form">
								<div class="lx-form-title">
									<h3>Confirmation suppression</h3>
								</div>
								<div class="lx-add-form">
									<div class="lx-delete-box">
										<p>Voulez vous vraiment supprimer cette commande?</p>
										<a href="javascript:;" class="lx-delete-record" data-action="deletecommand" data-id="">Oui</a>
										<a href="javascript:;" class="lx-cancel-delete">Non</a>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

		<!-- JQuery Script -->
		<script src="js/jquery-1.12.4.min.js"></script>
		<!-- Popup Script -->
		<script src="js/jquery.popup.js"></script>
		<!-- Calendar Script -->
		<script src="js/moment.min.js"></script>
		<script src="js/daterangepicker.js"></script>
		<!-- Main Script -->
		<script src="js/qrcode-reader.min.js"></script>
		<script src="js/script.js"></script>
		<script>
			$(document).ready(function(){
				loadConfirmation($(".lx-pagination ul").attr("data-state"));
				toDropDown();
			});
			$(function() {
				$(".qrcode-reader").qrCodeReader({
					callback: function(codes) {
						collectThis(codes);
					}
				});
				$('input[name="dateadd"]').daterangepicker({
					locale: {
					  format: 'DD/MM/YYYY'
					},
					ranges: {
						'Today': [moment(), moment()],
						'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
						'Last 7 Days': [moment().subtract(6, 'days'), moment()],
						'Last 30 Days': [moment().subtract(29, 'days'), moment()],
						'This Month': [moment().startOf('month'), moment().endOf('month')],
						'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
					},
					"linkedCalendars": false,
					"autoUpdateInput": false,
					"showCustomRangeLabel": false,
					"alwaysShowCalendars": true
					}, function(start, end, label) {
						$('input[name="dateadd"]').val(start.format('DD/MM/YYYY') + " - " + end.format('DD/MM/YYYY'));
						$('input[name="datestart"]').val(start.format('DD/MM/YYYY'));
						$('input[name="dateend"]').val(end.format('DD/MM/YYYY'));
						loadConfirmation($(".lx-pagination ul").attr("data-state"));
				});
				$('input[name="dateadd"]').on('cancel.daterangepicker', function(ev, picker) {
					$(this).val('');
					$('input[name="datestart"]').val('');
					$('input[name="dateend"]').val('');
					loadConfirmation($(".lx-pagination ul").attr("data-state"));
				});
				$('input[name="dateupdate"]').daterangepicker({
					locale: {
					  format: 'DD/MM/YYYY'
					},
					ranges: {
						'Today': [moment(), moment()],
						'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
						'Last 7 Days': [moment().subtract(6, 'days'), moment()],
						'Last 30 Days': [moment().subtract(29, 'days'), moment()],
						'This Month': [moment().startOf('month'), moment().endOf('month')],
						'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
					},
					"linkedCalendars": false,
					"autoUpdateInput": false,
					"showCustomRangeLabel": false,
					"alwaysShowCalendars": true
					}, function(start, end, label) {
						$('input[name="dateupdate"]').val(start.format('DD/MM/YYYY') + " - " + end.format('DD/MM/YYYY'));
						$('input[name="datestartupdate"]').val(start.format('DD/MM/YYYY'));
						$('input[name="dateendupdate"]').val(end.format('DD/MM/YYYY'));
						loadConfirmation($(".lx-pagination ul").attr("data-state"));
				});
				$('input[name="dateupdate"]').on('cancel.daterangepicker', function(ev, picker) {
					$(this).val('');
					$('input[name="datestartupdate"]').val('');
					$('input[name="dateendupdate"]').val('');
					loadConfirmation($(".lx-pagination ul").attr("data-state"));
				});
				$('input[name="datereport"]').daterangepicker({
					locale: {
					  format: 'DD/MM/YYYY'
					},
					ranges: {
						'Today': [moment(), moment()],
						'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
						'Last 7 Days': [moment().subtract(6, 'days'), moment()],
						'Last 30 Days': [moment().subtract(29, 'days'), moment()],
						'This Month': [moment().startOf('month'), moment().endOf('month')],
						'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
					},
					"linkedCalendars": false,
					"autoUpdateInput": false,
					"showCustomRangeLabel": false,
					"alwaysShowCalendars": true
					}, function(start, end, label) {
						$('input[name="datereport"]').val(start.format('DD/MM/YYYY') + " - " + end.format('DD/MM/YYYY'));
						$('input[name="datestartreport"]').val(start.format('DD/MM/YYYY'));
						$('input[name="dateendreport"]').val(end.format('DD/MM/YYYY'));
						loadConfirmation($(".lx-pagination ul").attr("data-state"));
				});
				$('input[name="datereport"]').on('cancel.daterangepicker', function(ev, picker) {
					$(this).val('');
					$('input[name="datestartreport"]').val('');
					$('input[name="dateendreport"]').val('');
					loadConfirmation($(".lx-pagination ul").attr("data-state"));
				});
				$('input[name="datereported"]').daterangepicker({
					locale: {
					  format: 'DD/MM/YYYY'
					},
					singleDatePicker: true,
					showDropdowns: true
				});
			});
		</script>
	</body>
</html>
<?php
DB_Sanitize();
}
?>