<?php

session_start();

include("config.php");



if(!isset($_SESSION['id'])){

	header('location: login.php');

}

else{

	if(!preg_match("#Mise à jour#",$_SESSION['roles'])){	

		header('location: 404.php');

	}

}



if(isset($_SESSION['id']) AND isset($_SESSION['fullname'])){

?>

<!DOCTYPE html>

<html lang="zxx">

	<head>

		<meta charset="utf-8">

		<title>StockOUT - CPanel</title>

		<meta name="description" content="StockOUT - CPanel">

		<meta name="viewport" content="width=device-width, initial-scale=1">

		<meta name="robots" content="noindex,nofollow" />

		<!-- General CSS Settings -->

		<link rel="stylesheet" href="css/general_style.css">

		<!-- Main Style of the template -->

		<link rel="stylesheet" href="css/main_style.php">

		<!-- Landing Page Style -->

		<link rel="stylesheet" href="css/reset_style.css">

		<!-- Awesomefont -->

		<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.4.1/css/all.css" integrity="sha384-5sAR7xN1Nv6T6+dT2mhtzEpVJvfS3NScPQTrOxhwjIuvcA67KV2R5Jz6kr4abQsz" crossorigin="anonymous">

		<!-- DateRangePicker -->

		<link rel="stylesheet" type="text/css" href="css/daterangepicker.css" />

		<!-- Fav Icon -->

		<link rel="shortcut icon" href="../favicon.ico">

		<?php include("onesignal.php");?>

	</head>

	<body>



		<!-- Wrapper -->

		<div class="lx-wrapper">

			<!-- Header -->

			<div class="lx-header">

				<?php include('header.php');?>

			</div>

			<!-- Main -->

			<div class="lx-main">

				<div class="lx-main-leftside">

					<?php include('mainmenu.php');?>

				</div>

				<!-- Main Content -->

				<div class="lx-main-content">

					<div class="lx-page-header">

						<h2>Mise à jour</h2>

					</div>

					<div class="lx-clear-fix"></div>

					<div class="lx-page-content">

						<div class="lx-g1">

							<div class="lx-table lx-table-updates">



							</div>

							<?php

							$nb = 20;

							if($parametres['nbrows'] != "" AND $parametres['nbrows'] != "0"){

								$nb = $parametres['nbrows'];

							}						

							?>

							<div class="lx-action-bulk">

								<label><span>Afficher: </span>

									<select name="nbrows">

										<option value="10" <?php if($nb==10){echo "selected";}?>>10</option>

										<option value="20" <?php if($nb==20){echo "selected";}?>>20</option>

										<option value="50" <?php if($nb==50){echo "selected";}?>>50</option>

										<option value="100" <?php if($nb==100){echo "selected";}?>>100</option>

										<option value="200" <?php if($nb==200){echo "selected";}?>>200</option>

									</select>

								</label><span>lignes par page</span>

							</div>

							<?php

							$back = $bdd->query("SELECT COUNT(*) AS nb FROM updates");

							$row = $back->fetch();

							?>

							<div class="lx-pagination" style="<?php if($row['nb'] <= $nb){echo "display:none;";}?>">

								<?php

								$nbpages = ceil($row['nb']/$nb);

								?>

								<ul data-table="updates" data-state="1" data-start="0" data-nbpage="<?php echo $nb;?>" data-posts="<?php echo $row['nb'];?>">

									<li><span>Page <ins>1</ins> sur <abbr><?php echo $nbpages;?></abbr></span></li>

									<li><a href="javascript:;" class="previous disabled"><i class="fa fa-angle-left"></i></a></li>

									<li>

										<select id="pgnumber">

											<?php

											for($i=1;$i<=$nbpages;$i++){

												?>

											<option value="<?php echo ($i-1);?>"><?php echo $i;?></option>

												<?php

											}

											?>

										</select>

									</li>

									<li><a href="javascript:;" class="next <?php if($nbpages == 1){echo 'disabled';}?>"><i class="fa fa-angle-right"></i></a></li>

								</ul>

								<div class="lx-clear-fix"></div>

							</div>

							<div class="lx-clear-fix"></div>

						</div>

						<div class="lx-clear-fix"></div>

					</div>

					<div class="lx-clear-fix"></div>

				</div>

				<div class="lx-clear-fix"></div>

			</div>

			<!-- End Popup -->

			<div tabindex="0" class="lx-popup update">

				<div class="lx-popup-inside">

					<div class="lx-popup-content">

						<div class="lx-popup-details">

							<div class="lx-form">

								<div class="lx-form-title">

									<h3>Mise à jour</h3>

								</div>

								<div class="lx-add-form">

									<div class="lx-start-update">

										<p>Veuillez ne pas quitter cette page jusqu'à que l'installation est terminée</p>

										<a href="javascript:;">Démarrer la mise à jour</a>

									</div>

								</div>

							</div>

						</div>

					</div>

				</div>

			</div>

		</div>



		<!-- JQuery Script -->

		<script src="js/jquery-1.12.4.min.js"></script>

		<!-- Popup Script -->

		<script src="js/jquery.popup.js"></script>

		<!-- Main Script -->

		<script src="js/script.js"></script>

		<script>

			$(document).ready(function(){

				loadUpdates($(".lx-pagination ul").attr("data-state"));

			});

		</script>

	</body>

</html>

<?php

DB_Sanitize();

}

?>