<?php
session_start();
include("config.php");

if(!isset($_SESSION['id'])){
	header('location: login.php');
}

if(isset($_SESSION['id']) AND isset($_SESSION['fullname'])){
?>
<!DOCTYPE html>
<html lang="zxx">
	<head>
		<meta charset="utf-8">
		<title><?php echo $settings['appname'];?> - CPanel</title>
		<meta name="description" content="<?php echo $settings['appname'];?> - CPanel">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<meta name="robots" content="noindex,nofollow" />
		<!-- General CSS Settings -->
		<link rel="stylesheet" href="css/general_style.css">
		<!-- Main Style of the template -->
		<link rel="stylesheet" href="css/main_style.php">
		<!-- Landing Page Style -->
		<link rel="stylesheet" href="css/reset_style.css">
		<!-- Awesomefont -->
		<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.4.1/css/all.css" integrity="sha384-5sAR7xN1Nv6T6+dT2mhtzEpVJvfS3NScPQTrOxhwjIuvcA67KV2R5Jz6kr4abQsz" crossorigin="anonymous">
		<!-- DateRangePicker -->
		<link rel="stylesheet" type="text/css" href="css/daterangepicker.css" />
		<!-- Fav Icon -->
		<link rel="shortcut icon" href="../favicon.ico">
		<?php include("onesignal.php");?>
	</head>
	<body>

		<!-- Wrapper -->
		<div class="lx-wrapper">	
			<!-- Header -->
			<div class="lx-header">
				<?php include('header.php');?>
			</div>
			<!-- Main -->
			<div class="lx-main">
				<div class="lx-main-leftside">
					<?php include('mainmenu.php');?>
				</div>
				<!-- Main Content -->
				<div class="lx-main-content">
					<div class="lx-page-header lx-pb-5">
						<h2>Statistiques</h2>
					</div>
					<?php
					$back = $bdd->query("SELECT fullname,dateactive FROM users WHERE type='worker' OR type='moderator' AND trash='1'");
					if($_SESSION['type'] == "moderator" AND $back->rowCount() > 0){
					?>
					<div class="lx-g1">
						<div class="lx-stats-bloc">
							<ul class="lx-workers-state">
								<?php
								while($row = $back->fetch()){
									$class = " lx-connected";
									if($row['dateactive'] != ""){
										if($row['dateactive'] < (time() - (60*20))){
											$class = " lx-disconnected";
										}
										elseif($row['dateactive'] < (time() - (60*10))){
											$class = " lx-halfconnected";
										}
									}
									else{
										$class = " lx-disconnected";
									}
									?>
								<li><i class="fa fa-circle<?php echo $class;?>"></i> <?php echo $row['fullname'];?></li>
									<?php
								}
								?>
							</ul>
						</div>
					</div>
					<?php
					}					
					?>
					<div class="lx-clear-fix"></div>
					<div class="lx-g1">
						<?php
						if($_SESSION['type'] == "affiliate" OR preg_match("#Responsable affiliate#",$_SESSION['roles'])){
							$back = $bdd->query("SELECT description,pictures FROM notices WHERE shown='on' AND type='Client Affiliate' AND trash='1'");
							while($row = $back->fetch()){
							?>
							<div class="lx-notices-item">
								<i class="fa fa-info-circle"></i>
								<p><?php echo $row['description'];?></p>
								<?php
								$picture = substr($row['pictures'],1);
								if($picture != ""){
									?>
								<img src="uploads/<?php echo $picture;?>" style="width:100%;" />
									<?php
								}
								?>
							</div>
							<?php
							}							
						}
						else{
							$back = $bdd->query("SELECT description,pictures FROM notices WHERE shown='on' AND (type='' OR type='Client Seller') AND trash='1'");
							while($row = $back->fetch()){
							?>
							<div class="lx-notices-item">
								<i class="fa fa-info-circle"></i>
								<p><?php echo $row['description'];?></p>
								<?php
								$picture = substr($row['pictures'],1);
								if($picture != ""){
									?>
								<img src="uploads/<?php echo $picture;?>" style="width:100%;" />
									<?php
								}
								?>
							</div>
							<?php
							}							
						}
						?>
					</div>
					<div class="lx-g1">
						<div class="lx-stats-bloc" style="max-height:1000px;">
							<div class="lx-keyword">
								<label style="<?php if($_SESSION['type'] != "moderator" OR $myclients != ""){echo "display:none;";}?>">
									<select name="manager" id="manager_kpi">
										<option value="">Tous les manager</option>
										<?php
										$back = $bdd->query("SELECT id,fullname,store FROM users WHERE type='moderator' AND roles LIKE '%Responsable%' AND trash='1' ORDER BY fullname");
										while($row = $back->fetch()){
											?>
										<option value="<?php echo $row['id'];?>"><?php echo $row['fullname'];?></option>
											<?php 
										}
										?>
									</select>
								</label>
								<label class="lx-advanced-select" style="<?php if($_SESSION['type'] != "moderator"){echo "display:none;";}?>">
									<i class="fa fa-caret-down"></i>
									<input type="text" name="worker" id="worker_kpi" placeholder="Choisissez un employé" data-ids="" readonly />
									<div>
										<a href="javascript:;" class="lx-state-empty">Vider</a>
										<a href="javascript:;" class="lx-state-filter">Filtrer</a>
										<div class="lx-clear-fix"></div>
										<input type="text" name="searchadvanced" style="margin-bottom:20px;" />
										<ul>
											<?php
											$back = $bdd->query("SELECT id,fullname,store FROM users WHERE type='worker' AND trash='1' ORDER BY fullname");
											if($_SESSION['type']=="worker"){
												$back = $bdd->query("SELECT id,fullname,store FROM users WHERE type='worker' AND id='".$_SESSION['id']."' AND trash='1' ORDER BY fullname");		
											}
											while($row = $back->fetch()){
												?>
											<li><label><input type="checkbox" value="<?php echo $row['fullname'];?>" data-ids="<?php echo $row['id'];?>" /> <?php echo $row['fullname'];?><del class="checkmark"></del></label></li>
												<?php
											}
											?>
										</ul>
									</div>
								</label>
								<label style="<?php if($_SESSION['type'] != "moderator" OR preg_match("#Responsable#",$_SESSION['roles'])){echo "display:none;";}?>">
									<select name="type" id="type_kpi">
										<option value="">Tous les compte</option>
										<option value="client" <?php echo preg_match("#Responsable seller#",$_SESSION['roles'])?"selected":"";?>>Clients Seller</option>
										<option value="affiliate" <?php echo preg_match("#Responsable affiliate#",$_SESSION['roles'])?"selected":"";?>>Clients Affiliate</option>
									</select>
								</label>								
								<label class="lx-advanced-select" style="<?php if($_SESSION['type'] != "moderator" OR preg_match("#Responsable affiliate#",$_SESSION['roles'])){echo "display:none;";}?>">
									<i class="fa fa-caret-down"></i>
									<input type="text" name="client" id="client_kpi" placeholder="Choisissez un client seller" data-ids="" readonly />
									<div>
										<a href="javascript:;" class="lx-state-empty">Vider</a>
										<a href="javascript:;" class="lx-state-filter">Filtrer</a>
										<div class="lx-clear-fix"></div>
										<input type="text" name="searchadvanced" style="margin-bottom:20px;" />
										<ul>
											<?php
											$back = $bdd->query("SELECT id,fullname,store FROM users WHERE type IN('client') AND trash='1'".$myclientsids." ORDER BY fullname");
											if($_SESSION['type']=="client"){
												$back = $bdd->query("SELECT id,fullname,store FROM users WHERE type IN('client') AND id='".$_SESSION['id']."' AND trash='1' ORDER BY fullname");		
											}
											while($row = $back->fetch()){
												?>
											<li><label><input type="checkbox" value="<?php echo $row['fullname']!=""?$row['fullname']:$row['store'];?>" data-ids="<?php echo $row['id'];?>" /> <?php echo $row['store']." (".$row['fullname'].")";?><del class="checkmark"></del></label></li>
												<?php
											}
											?>
										</ul>
									</div>
								</label>
								<label class="lx-advanced-select" style="<?php if($_SESSION['type'] != "moderator" OR preg_match("#Responsable seller#",$_SESSION['roles'])){echo "display:none;";}?>">
									<i class="fa fa-caret-down"></i>
									<input type="text" name="clientaff" id="clientaff_kpi" placeholder="Choisissez un client affiliate" data-ids="" readonly />
									<div>
										<a href="javascript:;" class="lx-state-empty">Vider</a>
										<a href="javascript:;" class="lx-state-filter">Filtrer</a>
										<div class="lx-clear-fix"></div>
										<input type="text" name="searchadvanced" style="margin-bottom:20px;" />
										<ul>
											<?php
											$back = $bdd->query("SELECT id,fullname,store FROM users WHERE type IN('affiliate') AND trash='1'".$myclientsids." ORDER BY fullname");
											if($_SESSION['type']=="client"){
												$back = $bdd->query("SELECT id,fullname,store FROM users WHERE type IN('affiliate') AND id='".$_SESSION['id']."' AND trash='1' ORDER BY fullname");		
											}
											while($row = $back->fetch()){
												?>
											<li><label><input type="checkbox" value="<?php echo $row['fullname']!=""?$row['fullname']:$row['store'];?>" data-ids="<?php echo $row['id'];?>" /> <?php echo $row['store']." (".$row['fullname'].")";?><del class="checkmark"></del></label></li>
												<?php
											}
											?>
										</ul>
									</div>
								</label>
								<label class="lx-advanced-select" style="<?php if($_SESSION['type'] != "moderator"){echo "display:none;";}?>">
									<i class="fa fa-caret-down"></i>
									<input type="text" name="dlm" id="dlm_kpi" placeholder="Choisissez un livreur" data-ids="" readonly />
									<div>
										<a href="javascript:;" class="lx-state-empty">Vider</a>
										<a href="javascript:;" class="lx-state-filter">Filtrer</a>
										<div class="lx-clear-fix"></div>
										<input type="text" name="searchadvanced" style="margin-bottom:20px;" />
										<ul>
											<?php
											$back = $bdd->query("SELECT id,fullname FROM users WHERE type='dlm' AND trash='1' ORDER BY fullname");
											if($_SESSION['type']=="dlm"){
												$back = $bdd->query("SELECT id,fullname FROM users WHERE type='dlm' AND id='".$_SESSION['id']."' AND trash='1' ORDER BY fullname");		
											}
											while($row = $back->fetch()){
												?>
											<li><label><input type="checkbox" value="<?php echo $row['fullname'];?>" data-ids="<?php echo $row['id'];?>" /> <?php echo $row['fullname'];?><del class="checkmark"></del></label></li>
												<?php
											}
											?>
										</ul>
									</div>
								</label>
								<label class="lx-advanced-select" style="<?php if($_SESSION['type'] != "moderator"){echo "display:none;";}?>">
									<i class="fa fa-caret-down"></i>
									<input type="text" name="subdlm" id="subdlm_kpi" placeholder="Choisissez un sous livreur" data-ids="" readonly />
									<div>
										<a href="javascript:;" class="lx-state-empty">Vider</a>
										<a href="javascript:;" class="lx-state-filter">Filtrer</a>
										<div class="lx-clear-fix"></div>
										<input type="text" name="searchadvanced" style="margin-bottom:20px;" />
										<ul>
											<?php
											$back = $bdd->query("SELECT id,fullname FROM users WHERE type='subdlm' AND trash='1' ORDER BY fullname");
											if($_SESSION['type']=="subdlm"){
												$back = $bdd->query("SELECT id,fullname FROM users WHERE type='subdlm' AND id='".$_SESSION['id']."' AND trash='1' ORDER BY fullname");		
											}
											while($row = $back->fetch()){
												?>
											<li><label><input type="checkbox" value="<?php echo $row['fullname'];?>" data-ids="<?php echo $row['id'];?>" /> <?php echo $row['fullname'];?><del class="checkmark"></del></label></li>
												<?php
											}
											?>
										</ul>
									</div>
								</label>
								<label class="lx-advanced-select">
									<i class="fa fa-caret-down"></i>
									<input type="text" name="city" id="city_kpi" placeholder="Choisissez une ville" data-ids="" readonly />
									<div>
										<a href="javascript:;" class="lx-state-empty">Vider</a>
										<a href="javascript:;" class="lx-state-filter">Filtrer</a>
										<div class="lx-clear-fix"></div>
										<input type="text" name="searchadvanced" style="margin-bottom:20px;" />
										<ul>
											<?php
											$back = $bdd->query("SELECT DISTINCT city FROM shippingfees WHERE trash='1' ORDER BY city");
											if($_SESSION['type'] == "dlm"){
												$back = $bdd->query("SELECT DISTINCT city FROM shippingfees WHERE trash='1' AND dlm='".$_SESSION['id']."' ORDER BY city");
											}
											while($row = $back->fetch()){
												?>
											<li><label><input type="checkbox" value="<?php echo $row['city'];?>" data-ids="<?php echo $row['city'];?>" /> <?php echo $row['city'];?><del class="checkmark"></del></label></li>
												<?php
											}
											?>
										</ul>
									</div>
								</label>
								<label class="lx-advanced-select" style="<?php if($_SESSION['type'] == "dlm"){echo "display:none;";}?>">
									<i class="fa fa-caret-down"></i>
									<input type="text" name="product" id="product_kpi" placeholder="Choisissez un produit" data-ids="" readonly />
									<div>
										<a href="javascript:;" class="lx-state-empty">Vider</a>
										<a href="javascript:;" class="lx-state-filter">Filtrer</a>
										<div class="lx-clear-fix"></div>
										<input type="text" name="searchadvanced" style="margin-bottom:20px;" />
										<ul>
											<?php
											$back = $bdd->query("SELECT id,title FROM stocks WHERE trash='1' ORDER BY id");
											if($_SESSION['type'] == "client"){
												$back = $bdd->query("SELECT id,title FROM stocks WHERE client='".$_SESSION['id']."' AND trash='1' ORDER BY id");
											}
											if($_SESSION['type'] == "dlm"){
												$back = $bdd->query("SELECT id,title FROM stocks WHERE 1=2");
											}
											if($_SESSION['type'] == "affiliate"){
												$back = $bdd->query("SELECT id,title FROM stocks WHERE (client='0' OR affiliate='on') AND trash='1' ORDER BY id");
											}
											while($row = $back->fetch()){
												?>
											<li><label><input type="checkbox" value="<?php echo $row['title'];?>" data-ids="<?php echo $row['id'];?>" /> <?php echo $row['title'];?><del class="checkmark"></del></label></li>
												<?php
											}
											?>
										</ul>
									</div>
								</label>
								<label><input type="text" name="dateadd" id="dateadd_kpi" value="<?php echo gmdate("d/m/Y",time()-(60*60*24*7))." - ".gmdate("d/m/Y");?>" placeholder="Tous les dates" readonly style="background:white;cursor:pointer;" /></label>
								<input type="hidden" name="datestart" id="datestart_kpi" value="<?php echo gmdate("d/m/Y",time()-(60*60*24*7));?>" />
								<input type="hidden" name="dateend" id="dateend_kpi" value="<?php echo gmdate("d/m/Y");?>" />
							</div>
							<div class="lx-kpis">

							</div>
						</div>
					</div>
					<div class="lx-clear-fix"></div>	
					<?php
					if($_SESSION['type'] == "affiliate"){
					?>
					<div class="lx-g3">
						<div class="lx-stats-bloc" style="text-align:center;">
							<h3>Contact et support</h3>
							<img src="images/contact.png" style="width:100px;margin:10px 0px;" />
							<br />
							<?php
							$back = $bdd->query("SELECT fullname,phone FROM users WHERE id IN(SELECT manager FROM users WHERE id='".$_SESSION['id']."') AND trash='1'");
							$row = $back->fetch();
							?>
							<p><?php echo $row['fullname'];?></p>
							<p><a href="tel:<?php echo $row['phone'];?>" style="color:#39add1;">Tél/WhatsApp: <?php echo $row['phone'];?></a></p>
							<p><a href="mailto:support@afriquedeal.com" style="color:#39add1;">Email: support@afriquedeal.com</a></p>
						</div>
					</div>
					<div class="lx-g3">
						<div class="lx-stats-bloc">
							<h3>Top 10 produits livré</h3>
							<div class="lx-table">
								<table cellspacing="0" cellspacing="0" style="border-bottom:1px solid #DDDDDD;">
									<tr>
										<td>#</td>
										<td>Produit</td>
										<td>Commission</td>
									</tr>
									<?php
									$i = 1;
									$back = $bdd->query("SELECT c.product,title,SUM(CASE WHEN c.price>=s.price THEN s.commission WHEN c.price>=s.price2 THEN commission2 WHEN c.price>=s.price3 THEN commission3 ELSE ROUND(commission3 - ((s.price3-c.price)*1.5/1000),2) END) AS com FROM commands c,stocks s WHERE s.commission>0 AND FIND_IN_SET(s.id,c.product) AND (s.client='0' OR affiliate='on') AND state='Livré' AND c.trash='1' AND c.client='".$_SESSION['id']."' GROUP BY c.product ORDER BY SUM(s.commission) LIMIT 0,10");
									while($row = $back->fetch()){
										?>
									<tr>
										<td><span><?php echo $i;?></span></td>
										<td><span><?php echo $row['title'];?></span></td>
										<td><span><?php echo $row['com'];?> $</span></td>
									</tr>
										<?php
										$i++;
									}
									?>
								</table>
							</div>
						</div>
					</div>
					<div class="lx-g3">
						<div class="lx-stats-bloc">
							<h3>Top 10 produits confirmé</h3>
							<div class="lx-table">
								<table cellspacing="0" cellspacing="0" style="border-bottom:1px solid #DDDDDD;">
									<tr>
										<td>#</td>
										<td>Produit</td>
										<td>Commission</td>
									</tr>
									<?php
									$i = 1;
									$back = $bdd->query("SELECT c.product,title,SUM(CASE WHEN c.price>=s.price THEN confirmedcom WHEN c.price>=s.price2 THEN confirmedcom3 WHEN c.price>=s.price3 THEN confirmedcom3 ELSE ROUND(confirmedcom3 - ((s.price3-c.price)*1.5/1000),2) END) AS com FROM commands c,stocks s WHERE confirmedcom>0 AND FIND_IN_SET(s.id,c.product) AND (s.client='0' OR affiliate='on') AND c.trash='1' AND c.client='".$_SESSION['id']."' GROUP BY c.product ORDER BY SUM(confirmedcom) LIMIT 0,10");
									while($row = $back->fetch()){
										?>
									<tr>
										<td><span><?php echo $i;?></span></td>
										<td><span><?php echo $row['title'];?></span></td>
										<td><span><?php echo $row['com'];?> $</span></td>
									</tr>
										<?php
										$i++;
									}
									?>
								</table>
							</div>
						</div>
					</div>
						<?php
					}
					?>
					<div class="lx-clear-fix"></div>	
					<?php
					if($_SESSION['type'] == "moderator"){
					?>
					<div class="lx-g1">
						<div class="lx-stats-bloc">
							<h3>Historique d'activités sur le site</h3>
							<div class="lx-keyword">
								<label><input type="text" name="datelog" id="datelog" value="<?php echo gmdate("d/m/Y");?>" placeholder="<?php echo gmdate("d/m/Y");?>" readonly style="background:white;cursor:pointer;" /></label>
							</div>
							<table cellpadding="0" cellspacing="0" id="loghistory">

							</table>
						</div>
					</div>
						<?php
					}
					?>
					<div class="lx-clear-fix"></div>
				</div>
			</div>
		</div>

		<!-- JQuery -->
		<script src="js/jquery-1.12.4.min.js"></script>
		<!-- Calendar Script -->
		<script src="js/moment.min.js"></script>
		<script src="js/daterangepicker.js"></script>
		<!-- Main Script -->
		<script src="js/script.js"></script>
		<script>
			$(function() {
				$('#dateadd').daterangepicker({
					locale: {
					  format: 'DD/MM/YYYY'
					},
					startDate: moment().startOf('day').subtract(30,'day'),
					endDate: moment(),
					ranges: {
						'Today': [moment(), moment()],
						'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
						'Last 7 Days': [moment().subtract(6, 'days'), moment()],
						'Last 30 Days': [moment().subtract(29, 'days'), moment()],
						'This Month': [moment().startOf('month'), moment().endOf('month')],
						'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
					},
					"linkedCalendars": false,
					"autoUpdateInput": false,
					"showCustomRangeLabel": false,
					"alwaysShowCalendars": true
					}, function(start, end, label) {
						$('#dateadd').val(start.format('DD/MM/YYYY') + " - " + end.format('DD/MM/YYYY'));
						$('#datestart').val(start.format('DD/MM/YYYY'));
						$('#dateend').val(end.format('DD/MM/YYYY'));
						//loadChartData();
						//loadChartData1();
				});
				$('#dateadd').on('cancel.daterangepicker', function(ev, picker) {
					$(this).val('');
					$('#datestart').val('');
					$('#dateend').val('');
					//loadChartData();
					//loadChartData1();
				});
				$('#dateadd_kpi').daterangepicker({
					locale: {
					  format: 'DD/MM/YYYY'
					},
					startDate: moment().startOf('day').subtract(30,'day'),
					endDate: moment(),
					ranges: {
						'Today': [moment(), moment()],
						'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
						'Last 7 Days': [moment().subtract(6, 'days'), moment()],
						'Last 30 Days': [moment().subtract(29, 'days'), moment()],
						'This Month': [moment().startOf('month'), moment().endOf('month')],
						'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
					},
					"linkedCalendars": false,
					"autoUpdateInput": false,
					"showCustomRangeLabel": false,
					"alwaysShowCalendars": true
					}, function(start, end, label) {
						$('#dateadd_kpi').val(start.format('DD/MM/YYYY') + " - " + end.format('DD/MM/YYYY'));
						$('#datestart_kpi').val(start.format('DD/MM/YYYY'));
						$('#dateend_kpi').val(end.format('DD/MM/YYYY'));
						loadKPI();
				});
				$('#dateadd_kpi').on('cancel.daterangepicker', function(ev, picker) {
					$(this).val('');
					$('#datestart_kpi').val('');
					$('#dateend_kpi').val('');
					loadKPI();
				});
				$('#dateadd_kpi2').daterangepicker({
					locale: {
					  format: 'DD/MM/YYYY'
					},
					startDate: moment().startOf('day').subtract(30,'day'),
					endDate: moment(),
					ranges: {
						'Today': [moment(), moment()],
						'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
						'Last 7 Days': [moment().subtract(6, 'days'), moment()],
						'Last 30 Days': [moment().subtract(29, 'days'), moment()],
						'This Month': [moment().startOf('month'), moment().endOf('month')],
						'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
					},
					"linkedCalendars": false,
					"autoUpdateInput": false,
					"showCustomRangeLabel": false,
					"alwaysShowCalendars": true
					}, function(start, end, label) {
						$('#dateadd_kpi2').val(start.format('DD/MM/YYYY') + " - " + end.format('DD/MM/YYYY'));
						$('#datestart_kpi2').val(start.format('DD/MM/YYYY'));
						$('#dateend_kpi2').val(end.format('DD/MM/YYYY'));
						//loadKPI2();
				});
				$('#dateadd_kpi2').on('cancel.daterangepicker', function(ev, picker) {
					$(this).val('');
					$('#datestart_kpi2').val('');
					$('#dateend_kpi2').val('');
					//loadKPI2();
				});
				$('#dateadd_rate').daterangepicker({
					locale: {
					  format: 'DD/MM/YYYY'
					},
					startDate: moment().startOf('day').subtract(30,'day'),
					endDate: moment(),
					ranges: {
						'Today': [moment(), moment()],
						'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
						'Last 7 Days': [moment().subtract(6, 'days'), moment()],
						'Last 30 Days': [moment().subtract(29, 'days'), moment()],
						'This Month': [moment().startOf('month'), moment().endOf('month')],
						'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
					},
					"linkedCalendars": false,
					"autoUpdateInput": false,
					"showCustomRangeLabel": false,
					"alwaysShowCalendars": true
					}, function(start, end, label) {
						$('#dateadd_rate').val(start.format('DD/MM/YYYY') + " - " + end.format('DD/MM/YYYY'));
						$('#datestart_rate').val(start.format('DD/MM/YYYY'));
						$('#dateend_rate').val(end.format('DD/MM/YYYY'));
						//loadDLMRate();
						//loadCityRate();
				});
				$('#dateadd_rate').on('cancel.daterangepicker', function(ev, picker) {
					$(this).val('');
					$('#datestart_rate').val('');
					$('#dateend_rate').val('');
					//loadDLMRate();
					//loadCityRate();
				});
				$('input[name="datelog"]').daterangepicker({
					locale: {
					  format: 'DD/MM/YYYY'
					},
					autoUpdateInput: false,
					singleDatePicker: true,
					showDropdowns: true
					}, function(start, end, label) {
						$('input[name="datelog"]').val(start.format('DD/MM/YYYY'));
						loadLog();
				});
			});
		</script>
		<script src="js/highcharts.js"></script>
		<script src="js/exporting.js"></script>		
	</body>
</html>
<?php
DB_Sanitize();
}
?>