<?php
session_start();
include("config.php");

if(!isset($_SESSION['id'])){
	header('location: login.php');
}

if(isset($_SESSION['id']) AND isset($_SESSION['fullname'])){
?>
<!DOCTYPE html>
<html lang="zxx">
	<head>
		<meta charset="utf-8">
		<title><?php echo $settings['appname'];?> - CPanel</title>
		<meta name="description" content="<?php echo $settings['appname'];?> - CPanel">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<meta name="robots" content="noindex,nofollow" />
		<!-- General CSS Settings -->
		<link rel="stylesheet" href="css/general_style.css?v=1.0">
		<!-- Main Style of the template -->
		<link rel="stylesheet" href="css/main_style.php?v=1.0">
		<!-- Landing Page Style -->
		<link rel="stylesheet" href="css/reset_style.css">
		<!-- Awesomefont -->
		<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.4.1/css/all.css" integrity="sha384-5sAR7xN1Nv6T6+dT2mhtzEpVJvfS3NScPQTrOxhwjIuvcA67KV2R5Jz6kr4abQsz" crossorigin="anonymous">
		<!-- DateRangePicker -->
		<link rel="stylesheet" type="text/css" href="css/daterangepicker.css" />
		<!-- Fav Icon -->
		<link rel="shortcut icon" href="../favicon.ico">
		<?php include("onesignal.php");?>
	</head>
	<body>

		<!-- Wrapper -->
		<div class="lx-wrapper">
			<!-- Header -->
			<div class="lx-header">
				<?php include('header.php');?>
			</div>
			<!-- Main -->
			<div class="lx-main">
				<div class="lx-main-leftside">
					<?php include('mainmenu.php');?>
				</div>
				<!-- Main Content -->
				<div class="lx-main-content">
					<div class="lx-page-header">
						<h2>Profit Simulator</h2>
					</div>
					<div class="lx-clear-fix"></div>
					<div class="lx-page-content">
						<div class="lx-g1">
							<div class="lx-add-form">
								<form action="#" method="post" id="simulatorform">
									<div class="lx-textfield lx-g7 lx-pb-0">
										<label><span>Product Cost: </span><input type="text" name="bprice" /></label>
									</div>
									<div class="lx-textfield lx-g7 lx-pb-0">
										<label><span>Product Charges: </span><input type="text" name="charges" /></label>
									</div>
									<div class="lx-textfield lx-g7 lx-pb-0">
										<label><span>Ads Cost: </span><input type="text" name="ads" /></label>
									</div>
									<div class="lx-textfield lx-g7 lx-pb-0">
										<label><span>Leads: </span><input type="text" name="leads" /></label>
									</div>
									<div class="lx-textfield lx-g7 lx-pb-0">
										<label><span>Confirmed: </span><input type="text" name="confirmed" /></label>
									</div>
									<div class="lx-textfield lx-g7 lx-pb-0">
										<label><span>Delivered: </span><input type="text" name="delivered" /></label>
									</div>
									<div class="lx-textfield lx-g7 lx-pb-0">
										<label><span>Selling Price: </span><input type="text" name="price" /></label>
									</div>
									<div class="lx-clear-fix"></div>
								</form>
								<div class="lx-profit-details">
									<div class="lx-textfield lx-g7 lx-pb-0">
										<p><strong>Confirmation rate: </strong><span class="confirmed">0%</span></p>
									</div>
									<div class="lx-textfield lx-g7 lx-pb-0">
										<p><strong>Delivery Rate: </strong><span class="delivered">0%</span></p>
									</div>
									<div class="lx-textfield lx-g7 lx-pb-0">
										<p><strong>Cost per lead: </strong><span class="cpl">0$</span></p>
									</div>
									<div class="lx-textfield lx-g7 lx-pb-0">
										<p><strong>Cost per confirmation: </strong><span class="cpc">0$</span></p>
									</div>
									<div class="lx-textfield lx-g7 lx-pb-0">
										<p><strong>Cost per delivery: </strong><span class="cpd">0$</span></p>
									</div>
									<div class="lx-textfield lx-g7 lx-pb-0">
										<p><strong>Product total cost: </strong><span class="tcost">0$</span></p>
									</div>
									<div class="lx-textfield lx-g7 lx-pb-0">
										<p><strong>Estimated profit: </strong><span class="profit">0$</span></p>
									</div>
								</div>
							</div>
							<div class="lx-clear-fix"></div>
						</div>
						<div class="lx-clear-fix"></div>
					</div>
					<div class="lx-clear-fix"></div>
				</div>
				<div class="lx-clear-fix"></div>
			</div>
		</div>

		<!-- JQuery Script -->
		<script src="js/jquery-1.12.4.min.js"></script>
		<!-- Popup Script -->
		<script src="js/jquery.popup.js"></script>
		<!-- Calendar Script -->
		<script src="js/moment.min.js"></script>
		<script src="js/daterangepicker.js"></script>
		<!-- Main Script -->
		<script src="js/script.js"></script>
		<script>
			$("#simulatorform input[type='text']").on("keyup paste change click",function(){
				var bprice = castEmptyToZero($("#simulatorform input[name='bprice']").val());
				var charges = castEmptyToZero($("#simulatorform input[name='charges']").val());
				var ads = castEmptyToZero($("#simulatorform input[name='ads']").val());
				var leads = castEmptyToZero($("#simulatorform input[name='leads']").val());
				var confirmed = castEmptyToZero($("#simulatorform input[name='confirmed']").val());
				var delivered = castEmptyToZero($("#simulatorform input[name='delivered']").val());
				var price = castEmptyToZero($("#simulatorform input[name='price']").val());
				
				$(".confirmed").text(castNaNToZero(confirmed * 100 / leads).toFixed(2) + "%");
				$(".delivered").text(castNaNToZero(delivered * 100 / confirmed).toFixed(2) + "%");
				$(".cpl").text(castNaNToZero(ads / leads).toFixed(2) + "$");
				$(".cpc").text(castNaNToZero(ads / confirmed).toFixed(2) + "$");
				$(".cpd").text(castNaNToZero(ads / delivered).toFixed(2) + "$");
				$(".tcost").text((bprice + charges + castNaNToZero(ads / delivered)).toFixed(2) + "$");
				$(".profit").text((price - (bprice + charges + castNaNToZero(ads / delivered))).toFixed(2) + "$");
			});
			
			function castEmptyToZero(value) {
				return value === "" ? 0 : parseFloat(value);
			}
			
			function castNaNToZero(value) {
				return isNaN(value) ? 0 : value;
			}
		</script>
	</body>
</html>
<?php
DB_Sanitize();
}
?>