<?php
session_start();
include("config.php");

if(!isset($_SESSION['id'])){
	header('location: login.php');
}
else{
	if(!preg_match("#Outsourcing#",$_SESSION['roles']) AND $_SESSION['type'] == "moderator"){
		header('location: 404.php');
	}
}

if(isset($_SESSION['id']) AND isset($_SESSION['fullname'])){
?>
<!DOCTYPE html>
<html lang="zxx">
	<head>
		<meta charset="utf-8">
		<title><?php echo $settings['appname'];?> - CPanel</title>
		<meta name="description" content="<?php echo $settings['appname'];?> - CPanel">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<meta name="robots" content="noindex,nofollow" />
		<!-- General CSS Settings -->
		<link rel="stylesheet" href="css/general_style.css">
		<!-- Main Style of the template -->
		<link rel="stylesheet" href="css/main_style.php">
		<!-- Landing Page Style -->
		<link rel="stylesheet" href="css/reset_style.css">
		<!-- Awesomefont -->
		<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.4.1/css/all.css" integrity="sha384-5sAR7xN1Nv6T6+dT2mhtzEpVJvfS3NScPQTrOxhwjIuvcA67KV2R5Jz6kr4abQsz" crossorigin="anonymous">
		<!-- DateRangePicker -->
		<link rel="stylesheet" type="text/css" href="css/daterangepicker.css" />
		<!-- Fav Icon -->
		<link rel="shortcut icon" href="../favicon.ico">
		<?php include("onesignal.php");?>
	</head>
	<body>

		<!-- Wrapper -->
		<div class="lx-wrapper">
			<!-- Header -->
			<div class="lx-header">
				<?php include('header.php');?>
			</div>
			<!-- Main -->
			<div class="lx-main">
				<div class="lx-main-leftside">
					<?php include('mainmenu.php');?>
				</div>
				<!-- Main Content -->
				<div class="lx-main-content">
					<div class="lx-page-header">
						<h2>Outsourcing</h2>
					</div>
					<div class="lx-clear-fix"></div>
					<div class="lx-page-content">
						<div class="lx-g1">
							<div class="lx-keyword">
								<label><a href="javascript:;" class="lx-search-keyword"><i class="fa fa-search"></i></a><input type="text" name="keyword" id="keyword" placeholder="Mot clé" data-table="outsourcing" /></label>
									<label style="<?php if($_SESSION['type'] != "moderator" OR $myclients != ""){echo "display:none;";}?>">
										<select name="manager" id="manager">
											<option value="">Tous les manager</option>
											<?php
											$back = $bdd->query("SELECT id,fullname,store FROM users WHERE type='moderator' AND roles LIKE '%Responsable%' AND trash='1' ORDER BY fullname");
											while($row = $back->fetch()){
												?>
											<option value="<?php echo $row['id'];?>"><?php echo $row['fullname'];?></option>
												<?php 
											}
											?>
										</select>
									</label>
									<label class="lx-advanced-select" style="<?php if($_SESSION['type'] != "moderator" OR $myclients != ""){echo "display:none;";}?>">
										<i class="fa fa-caret-down"></i>
										<input type="text" name="client" id="clients" placeholder="Choisissez un client" data-ids="" readonly />
										<div>
											<a href="javascript:;" class="lx-state-empty">Vider</a>
											<a href="javascript:;" class="lx-state-filter">Filtrer</a>
											<div class="lx-clear-fix"></div>
											<input type="text" name="searchadvanced" style="margin-bottom:20px;" />
											<ul>
												<?php
												$back = $bdd->query("SELECT id,fullname,store FROM users WHERE type IN('client') AND trash='1'".$myclientsids." ORDER BY fullname");
												while($row = $back->fetch()){
													?>
												<li><label><input type="checkbox" value="<?php echo $row['fullname']!=""?$row['fullname']:$row['store'];?>" data-ids="<?php echo $row['id'];?>" /> <?php echo $row['store']." (".$row['fullname'].")";?><del class="checkmark"></del></label></li>
													<?php
												}
												?>
											</ul>
										</div>
									</label>
									<label class="lx-advanced-select">
										<i class="fa fa-caret-down"></i>
										<input type="text" name="state" id="states" value="<?php if(isset($_GET['s'])){if(sanitize_vars($_GET['s']) != ""){echo sanitize_vars($_GET['s']);}}?>" placeholder="Choisissez une état" readonly />
										<div>
											<a href="javascript:;" class="lx-state-empty">Vider</a>
											<a href="javascript:;" class="lx-state-filter">Filtrer</a>
											<div class="lx-clear-fix"></div>
											<input type="text" name="searchadvanced" style="margin-bottom:20px;" />
											<ul>
												<?php
												$back = $bdd->query("SELECT state FROM trackingstates WHERE phase LIKE '%Sourcing%' AND trash='1' ORDER BY state");
												while($row = $back->fetch()){
													?>
												<li><label><input type="checkbox" value="<?php echo $row['state'];?>" /> <?php echo $row['state'];?><del class="checkmark"></del></label></li>
													<?php
												}
												?>
											</ul>
										</div>
									</label>
									<label style="<?php if($_SESSION['type'] != "moderator" OR $myclients != ""){echo "display:none;";}?>">
										<select name="treated" id="treated">
											<option value="">Traité: Tous</option>
											<option value="off">Traité: Non</option>
											<option value="on">Traité: Oui</option>
										</select>
									</label>
									<label><input type="text" name="dateadd" id="dateadd" data-table="commands" placeholder="Date" readonly style="cursor:pointer;" /></label>
									<input type="hidden" name="datestart" id="datestart" />
									<input type="hidden" name="dateend" id="dateend" />
									<input type="hidden" name="sortby" value="" />
									<input type="hidden" name="orderby" value="DESC" />
							</div>
							<div class="lx-add-form">
								<?php
								if($_SESSION['type'] == "client"){
								?>
								<a href="javascript:;" class="lx-new lx-new-outsourcing lx-open-popup" data-title="outsourcing">+ New</a>
								<?php
								}
								?>
							</div>
							<div class="lx-table lx-table-outsourcing">

							</div>
							<?php
							if($_SESSION['type'] == "moderator"){
							?>
							<div class="lx-action-bulk">
								<label><span>Action: </span>
									<select name="statebulk">
										<option value="">Select action</option>
										<option value="delete">Delete to trash</option>
										<option value="deletepermenantly">Delete definitely</option>
										<option value="restore">Restore</option>
									</select>
								</label>
								<a href="javascript:;">Apply</a>
							</div>
							<?php
							}
							$nb = 12;					
							?>
							<div class="lx-action-bulk">
								<label><span>Show: </span>
									<select name="nbrows">
										<option value="12" <?php if($nb==12){echo "selected";}?>>12</option>
										<option value="20" <?php if($nb==20){echo "selected";}?>>20</option>
										<option value="50" <?php if($nb==50){echo "selected";}?>>50</option>
										<option value="100" <?php if($nb==100){echo "selected";}?>>100</option>
										<option value="250" <?php if($nb==250){echo "selected";}?>>250</option>
										<option value="500" <?php if($nb==500){echo "selected";}?>>500</option>
									</select>
								</label><span>Lines per page</span>
							</div>
							<?php
							$back = $bdd->query("SELECT COUNT(*) AS nb FROM outsourcing WHERE trash='1'".$userwhere);
							$row = $back->fetch();
							?>
							<div class="lx-pagination" style="<?php if($row['nb'] <= $nb){echo "display:none;";}?>">
								<?php
								$nbpages = ceil($row['nb']/$nb);
								?>
								<ul data-table="outsourcing" data-state="1" data-start="0" data-nbpage="<?php echo $nb;?>" data-posts="<?php echo $row['nb'];?>">
									<li><span>Page <ins>1</ins> of <abbr><?php echo $nbpages;?></abbr></span></li>
									<li><a href="javascript:;" class="previous disabled"><i class="fa fa-angle-left"></i></a></li>
									<li>
										<select id="pgbumber">
											<?php
											for($i=1;$i<=$nbpages;$i++){
												?>
											<option value="<?php echo ($i-1);?>"><?php echo $i;?></option>
												<?php
											}
											?>
										</select>
									</li>
									<li><a href="javascript:;" class="next <?php if($nbpages == 1){echo 'disabled';}?>"><i class="fa fa-angle-right"></i></a></li>
								</ul>
								<div class="lx-clear-fix"></div>
							</div>
							<div class="lx-clear-fix"></div>
						</div>
						<div class="lx-clear-fix"></div>
					</div>
					<div class="lx-clear-fix"></div>
				</div>
				<div class="lx-clear-fix"></div>
			</div>
			<!-- End Popup -->
			<div tabindex="0" class="lx-popup outsourcing">
				<div class="lx-popup-inside">
					<div class="lx-popup-content">
						<a href="javascript:;"><i class="material-icons">close</i></a>
						<div class="lx-popup-details">
							<div class="lx-form">
								<div class="lx-form-title">
									<h3>Update outsourcing</h3>
								</div>
								<div class="lx-add-form">
									<form action="#" method="post" id="outsourcingform">
										<div class="lx-textfield lx-g1 lx-pb-0">
											<label><span>Product:</span>
												<select name="stock">
													<option value="0">New product</option>
													<?php
													$back = $bdd->query("SELECT * FROM stocks WHERE (client='".$_SESSION['id']."' OR seller='on')");
													while($row = $back->fetch()){
														?>
													<option value="<?php echo $row['id'];?>"><?php echo $row['title'];?></option>
														<?php
													}
													?>
												</select>
											</label>
										</div>
										<div class="lx-clear-fix"></div>
										<div class="lx-textfield lx-g1 lx-pb-0 ifnewstock" style="display:none;">
											<label><span>Title: </span><input type="text" name="title" data-isnotempty="" data-message="Enter a title!!" /></label>
										</div>	
										<div class="lx-clear-fix"></div>
										<div class="lx-textfield lx-g1 lx-pb-0">
											<label><span>Quantity: </span><input type="text" name="qty" data-isnumber="" data-message="Enter a quantity!!" /></label>
										</div>	
										<div class="lx-clear-fix"></div>
										<div class="lx-textfield lx-g2 lx-pb-0" style="<?php echo $_SESSION['type']!="moderator"?"display:none;":"";?>">
											<label><span>Price unit: </span><input type="text" name="uprice" /></label>
										</div>	
										<div class="lx-textfield lx-g2 lx-pb-0" style="<?php echo $_SESSION['type']!="moderator"?"display:none;":"";?>">
											<label><span>Price total: </span><input type="text" name="tprice" /></label>
										</div>	
										<div class="lx-clear-fix"></div>
										<div class="lx-textfield lx-g1 lx-pb-0">
											<label><span>Description: </span><textarea type="text" name="description"></textarea></label>
										</div>
										<div class="lx-clear-fix"></div>
										<div class="lx-textfield lx-g1 lx-pb-0">
											<label><span>Link product: </span><input type="text" name="link" data-isnotempty="" data-message="Enter a link!!" /></label>
										</div>
										<div class="lx-clear-fix"></div>
										<div class="lx-textfield lx-g1 lx-pb-0">
											<input type="file" name="medias" id="medias" accept="image/x-png,image/jpeg" />
											<input type="hidden" name="picture" value="" data-isnotempty="" data-message="Uploader une image!!" />
											<a href="javascript:;" class="lx-upload-picture" style="background:#F8F8F8;color:#242424;border:1px solid #EEEEEE;"><i class="fa fa-camera"></i> Ajouter une image</a>
											<i class="fa fa-check" style="display:none;color:#7EC855;"></i>
										</div>
										<div class="lx-clear-fix"></div>
										<div class="lx-textfield lx-g1 lx-pb-0">
											<label><span>Shipping Method:</span>
												<select name="shipping">
													<option value="">Select a method</option>
													<option value="Air Freight">Air Freight</option>
													<option value="Sea Freight">Sea Freight</option>
													<option value="Raod Freight">Road Freight</option>
												</select>
											</label>
										</div>										
										<div class="lx-clear-fix"></div>							
										<div class="lx-submit lx-g1 lx-pb-0">
											<input type="hidden" name="id" value="0" />
											<a href="javascript:;">Save</a>
										</div>
									</form>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- End Popup -->	
			<div tabindex="0" class="lx-popup editstatesourcing">
				<div class="lx-popup-inside">
					<div class="lx-popup-content">
						<a href="javascript:;"><i class="material-icons">close</i></a>
						<div class="lx-popup-details">
							<div class="lx-form">
								<div class="lx-form-title">
									<h3>Edit status</h3>
								</div>
								<div class="lx-add-form">
									<form action="#" method="post" id="editstatesourcingform">
										<div class="lx-textfield lx-g1 lx-pb-0">
											<?php
											$back = $bdd->query("SELECT state,color FROM trackingstates WHERE phase='Sourcing' AND trash='1' ORDER BY state");	
											while($row = $back->fetch()){
												?>
											<a href="javascript:;" class="lx-sourcing-state" data-state="<?php echo $row['state'];?>" style="font-weight:500;background:<?php echo $row['color'];?>;color:#FFFFFF;"><?php echo $row['state'];?></a>
												<?php
											}
											?>
											<input type="hidden" name="state" data-required="yes" /></label>
										</div>
										<div class="lx-clear-fix"></div>
										<div class="lx-submit lx-g1 lx-pb-0">
											<input type="hidden" name="id" value="0" />
											<a href="javascript:;">Save</a>
										</div>
									</form>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- End Popup -->
			<div tabindex="0" class="lx-popup zoombox">
				<div class="lx-popup-inside">
					<div class="lx-popup-content">
						<a href="javascript:;"><i class="material-icons">close</i></a>
						<div class="lx-popup-details">
							<div class="lx-zoombox">
								<div class="lx-zoombox-content">
									
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- End Popup -->	
			<div tabindex="0" class="lx-popup deleterecord">
				<div class="lx-popup-inside">
					<div class="lx-popup-content">
						<a href="javascript:;"><i class="material-icons">close</i></a>
						<div class="lx-popup-details">
							<div class="lx-form">
								<div class="lx-form-title">
									<h3>Deletion confirmation</h3>
								</div>
								<div class="lx-add-form">
									<div class="lx-delete-box">
										<p>Do you really want to delete this demande?</p>
										<a href="javascript:;" class="lx-delete-record" data-action="deleteoutsourcing" data-id="">Yes</a>
										<a href="javascript:;" class="lx-cancel-delete">No</a>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

		<!-- JQuery Script -->
		<script src="js/jquery-1.12.4.min.js"></script>
		<!-- Popup Script -->
		<script src="js/jquery.popup.js"></script>
		<!-- Calendar Script -->
		<script src="js/moment.min.js"></script>
		<script src="js/daterangepicker.js"></script>
		<!-- Main Script -->
		<script src="js/script.js"></script>
		<script>
			$(document).ready(function(){
				loadOutSourcing($(".lx-pagination ul").attr("data-state"));
			});
			
			$(function() {
				$('input[name="dateadd"]').daterangepicker({
					locale: {
					  format: 'DD/MM/YYYY'
					},
					ranges: {
						'Today': [moment(), moment()],
						'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
						'Last 7 Days': [moment().subtract(6, 'days'), moment()],
						'Last 30 Days': [moment().subtract(29, 'days'), moment()],
						'This Month': [moment().startOf('month'), moment().endOf('month')],
						'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
					},
					"linkedCalendars": false,
					"autoUpdateInput": false,
					"showCustomRangeLabel": false,
					"alwaysShowCalendars": true
					}, function(start, end, label) {
						$('input[name="dateadd"]').val(start.format('DD/MM/YYYY') + " - " + end.format('DD/MM/YYYY'));
						$('input[name="datestart"]').val(start.format('DD/MM/YYYY'));
						$('input[name="dateend"]').val(end.format('DD/MM/YYYY'));
						loadCommands($(".lx-pagination ul").attr("data-state"));
				});
				$('input[name="dateadd"]').on('cancel.daterangepicker', function(ev, picker) {
					$(this).val('');
					$('input[name="datestart"]').val('');
					$('input[name="dateend"]').val('');
					loadCommands($(".lx-pagination ul").attr("data-state"));
				});
			});
		</script>
	</body>
</html>
<?php
DB_Sanitize();
}
?>