<?php
session_start();
include("config.php");

if(!isset($_SESSION['id'])){
	header('location: login.php');
}
else{
	if(!preg_match("#Tracking Status#",$_SESSION['roles'])){	
		header('location: 404.php');
	}
}

if(isset($_SESSION['id']) AND isset($_SESSION['fullname'])){
?>
<!DOCTYPE html>
<html lang="zxx">
	<head>
		<meta charset="utf-8">
		<title><?php echo $settings['appname'];?> - CPanel</title>
		<meta name="description" content="<?php echo $settings['appname'];?> - CPanel">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<meta name="robots" content="noindex,nofollow" />
		<!-- General CSS Settings -->
		<link rel="stylesheet" href="css/general_style.css">
		<!-- Main Style of the template -->
		<link rel="stylesheet" href="css/main_style.php">
		<!-- Landing Page Style -->
		<link rel="stylesheet" href="css/reset_style.css">
		<!-- Awesomefont -->
		<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.4.1/css/all.css" integrity="sha384-5sAR7xN1Nv6T6+dT2mhtzEpVJvfS3NScPQTrOxhwjIuvcA67KV2R5Jz6kr4abQsz" crossorigin="anonymous">
		<!-- DateRangePicker -->
		<link rel="stylesheet" type="text/css" href="css/daterangepicker.css" />
		<!-- Fav Icon -->
		<link rel="shortcut icon" href="../favicon.ico">
		<?php include("onesignal.php");?>
	</head>
	<body>

		<!-- Wrapper -->
		<div class="lx-wrapper">
			<!-- Header -->
			<div class="lx-header">
				<?php include('header.php');?>
			</div>
			<!-- Main -->
			<div class="lx-main">
				<div class="lx-main-leftside">
					<?php include('mainmenu.php');?>
				</div>
				<!-- Main Content -->
				<div class="lx-main-content">
					<div class="lx-page-header">
						<h2>Tracking Status</h2>
					</div>
					<div class="lx-clear-fix"></div>
					<div class="lx-page-content">
						<div class="lx-g1">
							<div class="lx-keyword">
								<label><a href="javascript:;" class="lx-search-keyword"><i class="fa fa-search"></i></a><input type="text" name="keyword" id="keyword" placeholder="Keyword" data-table="trackingstates" /></label>
								<input type="hidden" name="sortby" value="" />
								<input type="hidden" name="orderby" value="DESC" />
							</div>
							<div class="lx-add-form">
								<a href="javascript:;" class="lx-new lx-new-trackingstate lx-open-popup" data-title="trackingstate">+ New</a>
							</div>
							<div class="lx-table lx-table-trackingstates">

							</div>
							<div class="lx-action-bulk">
								<label><span>Action: </span>
									<select name="statebulk">
										<option value="">Select action</option>
										<option value="delete">Delete to trash</option>
										<option value="deletepermenantly">Delete definitely</option>
										<option value="restore">Restore</option>
									</select>
								</label>
								<a href="javascript:;">Apply</a>
							</div>
							<?php
							$nb = 20;
							if($parametres['nbrows'] != "" AND $parametres['nbrows'] != "0"){
								$nb = $parametres['nbrows'];
							}						
							?>
							<div class="lx-action-bulk">
								<label><span>Show: </span>
									<select name="nbrows">
										<option value="20" <?php if($nb==20){echo "selected";}?>>20</option>
										<option value="50" <?php if($nb==50){echo "selected";}?>>50</option>
										<option value="100" <?php if($nb==100){echo "selected";}?>>100</option>
										<option value="250" <?php if($nb==250){echo "selected";}?>>250</option>
										<option value="500" <?php if($nb==500){echo "selected";}?>>500</option>
									</select>
								</label><span>Lines per page</span>
							</div>
							<?php
							$back = $bdd->query("SELECT COUNT(*) AS nb FROM trackingstates WHERE trash='1'");
							$row = $back->fetch();
							?>
							<div class="lx-pagination" style="<?php if($row['nb'] <= $nb){echo "display:none;";}?>">
								<?php
								$nbpages = ceil($row['nb']/$nb);
								?>
								<ul data-table="trackingstates" data-state="1" data-start="0" data-nbpage="<?php echo $nb;?>" data-posts="<?php echo $row['nb'];?>">
									<li><span>Page <ins>1</ins> of <abbr><?php echo $nbpages;?></abbr></span></li>
									<li><a href="javascript:;" class="previous disabled"><i class="fa fa-angle-left"></i></a></li>
									<li>
										<select id="pgbumber">
											<?php
											for($i=1;$i<=$nbpages;$i++){
												?>
											<option value="<?php echo ($i-1);?>"><?php echo $i;?></option>
												<?php
											}
											?>
										</select>
									</li>
									<li><a href="javascript:;" class="next <?php if($nbpages == 1){echo 'disabled';}?>"><i class="fa fa-angle-right"></i></a></li>
								</ul>
								<div class="lx-clear-fix"></div>
							</div>
							<div class="lx-clear-fix"></div>
						</div>
						<div class="lx-clear-fix"></div>
					</div>
					<div class="lx-clear-fix"></div>
				</div>
				<div class="lx-clear-fix"></div>
			</div>
			<!-- End Popup -->
			<div tabindex="0" class="lx-popup trackingstate">
				<div class="lx-popup-inside">
					<div class="lx-popup-content">
						<a href="javascript:;"><i class="material-icons">close</i></a>
						<div class="lx-popup-details">
							<div class="lx-form">
								<div class="lx-form-title">
									<h3>Update tracking status</h3>
								</div>
								<div class="lx-add-form">
									<form action="#" method="post" id="trackingstatesform">
										<div class="lx-textfield lx-g2 lx-pb-0">
											<label><span>Status: </span><input type="text" name="state" placeholder="Ex: Delivered" data-isnotempty="" data-message="Enter a status!!" /></label>
										</div>
										<div class="lx-textfield lx-g2 lx-pb-0">
											<label><span>Color: </span><input type="text" name="color" placeholder="Ex: #FF0000" data-isnotempty="" data-message="Enter a color!!" /></label>
										</div>
										<div class="lx-clear-fix"></div>
										<div class="lx-textfield lx-g1 lx-pb-0">
											<div class="lx-table">
												<table cellpadding="0" cellspacing="0">
													<tr>
														<td colspan="3">User</td>
													</tr>
													<tr>
														<td><label><input type="checkbox" name="agents" value="Moderator" /> Moderator<del class="checkmark"></del></label> &nbsp; 
														<label><input type="checkbox" name="agents" value="Delivery man" /> Delivery man<del class="checkmark"></del></label> &nbsp; 
														<label><input type="checkbox" name="agents" value="Client" /> Client<del class="checkmark"></del></label></td>
													</tr>
												</table>
											</div>
											<input type="hidden" name="agentstext" value="" />
										</div>	
										<div class="lx-clear-fix"></div>
										<div class="lx-textfield lx-g1 lx-pb-0">
											<div class="lx-table">
												<table cellpadding="0" cellspacing="0">
													<tr>
														<td colspan="3">Phase</td>
													</tr>
													<tr>
														<td>
															<label><input type="checkbox" name="phases" value="Confirmation" /> Confirmation<del class="checkmark"></del></label> &nbsp; 
															<label><input type="checkbox" name="phases" value="Shipping" /> Shipping<del class="checkmark"></del></label> &nbsp; 
															<label><input type="checkbox" name="phases" value="Sourcing" /> Sourcing<del class="checkmark"></del></label> &nbsp; 
														</td>
													</tr>
												</table>
											</div>
											<input type="hidden" name="phasestext" value="" />
										</div>	
										<div class="lx-clear-fix"></div>
										<div class="lx-textfield lx-g1 lx-pb-0">
											<div class="lx-table">
												<table cellpadding="0" cellspacing="0">
													<tr>
														<td colspan="3">Statistics Placements</td>
													</tr>
													<tr>
														<td>
														<label><input type="checkbox" name="kpi" value="All (Confirmation)" /> All (Confirmation)<del class="checkmark"></del></label> &nbsp; 
														<label><input type="checkbox" name="kpi" value="New" /> New<del class="checkmark"></del></label> &nbsp; 
														<label><input type="checkbox" name="kpi" value="Confirmed" /> Confirmed<del class="checkmark"></del></label> &nbsp; 
														<label><input type="checkbox" name="kpi" value="Reported (Confirmation)" /> Reported (Confirmation)<del class="checkmark"></del></label> &nbsp; 
														<label><input type="checkbox" name="kpi" value="Not answering (Confirmation)" /> Not answering (Confirmation)<del class="checkmark"></del></label> &nbsp; 
														<label><input type="checkbox" name="kpi" value="Canceled (Confirmation)" /> Canceled (Confirmation)<del class="checkmark"></del></label> &nbsp; 
														<label><input type="checkbox" name="kpi" value="All (Shipping)" /> All (Shipping)<del class="checkmark"></del></label> &nbsp; 
														<label><input type="checkbox" name="kpi" value="Delivered" /> Delivered<del class="checkmark"></del></label> &nbsp; 
														<label><input type="checkbox" name="kpi" value="Out for delivery" /> Out for delivery<del class="checkmark"></del></label> &nbsp; 
														<label><input type="checkbox" name="kpi" value="Not answering (Shipping)" /> Not answering (Shipping)<del class="checkmark"></del></label> &nbsp; 
														<label><input type="checkbox" name="kpi" value="Reported & Interested (Shipping)" /> Reported & Interested (Shipping)<del class="checkmark"></del></label> &nbsp; 
														<label><input type="checkbox" name="kpi" value="Canceled & Refused (Shipping)" /> Canceled & Refused (Shipping)<del class="checkmark"></del></label>
														</td>
													</tr>
												</table>
											</div>
											<input type="hidden" name="kpitext" value="" />
										</div>	
										<div class="lx-clear-fix"></div>
										<div class="lx-submit lx-g1 lx-pb-0">
											<input type="hidden" name="id" value="0" />
											<a href="javascript:;">Save</a>
										</div>
									</form>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- End Popup -->	
			<div tabindex="0" class="lx-popup deleterecord">
				<div class="lx-popup-inside">
					<div class="lx-popup-content">
						<a href="javascript:;"><i class="material-icons">close</i></a>
						<div class="lx-popup-details">
							<div class="lx-form">
								<div class="lx-form-title">
									<h3>Deletion confirmation</h3>
								</div>
								<div class="lx-add-form">
									<div class="lx-delete-box">
										<p>Do you really want to delete this tracking status?</p>
										<a href="javascript:;" class="lx-delete-record" data-action="deletetrackingstate" data-id="">Yes</a>
										<a href="javascript:;" class="lx-cancel-delete">No</a>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

		<!-- JQuery Script -->
		<script src="js/jquery-1.12.4.min.js"></script>
		<!-- Popup Script -->
		<script src="js/jquery.popup.js"></script>
		<!-- Main Script -->
		<script src="js/script.js"></script>
		<script>
			$(document).ready(function(){
				loadTrackingstates($(".lx-pagination ul").attr("data-state"));
			});
		</script>
	</body>
</html>
<?php
DB_Sanitize();
}
?>